/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.controller;

import de.uniba.minf.auth.spring.mvc.AuthInfoHelper;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.pojo.NotePojo;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.NoteRepository;
import de.uniba.minf.registry.repository.VocabularyDefinitionRepository;
import de.uniba.minf.registry.service.EntityDefinitionService;
import de.unibamberg.minf.core.web.controller.BaseTranslationController;
import de.unibamberg.minf.core.web.exception.NotFoundException;
import de.unibamberg.minf.core.web.init.LocaleAwareInitializationService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;

public class BaseViewController
extends BaseTranslationController {
    @Autowired
    protected EntityDefinitionService entityDefinitionService;
    @Autowired
    protected EntityDefinitionRepository entityDefinitionRepository;
    @Autowired
    protected EntityRepository entityRepository;
    @Autowired
    protected VocabularyDefinitionRepository vocabularyDefinitionRepository;
    @Autowired
    private NoteRepository noteRepository;
    @Autowired
    private LocaleAwareInitializationService initService;
    @Autowired
    protected AuthInfoHelper authInfoHelper;
    @Value(value="${baseUrl}")
    protected String baseUrl;

    @ModelAttribute(value="primaryEntityDefinitions")
    public Collection<EntityDefinition> getPrimaryEntityDefinitionsOrAll() {
        Collection primary = this.getPrimaryEntityDefinitions();
        if (primary.isEmpty()) {
            primary = this.getSecondaryEntityDefinitions();
        }
        return primary;
    }

    @ModelAttribute(value="secondaryEntityDefinitions")
    public Collection<EntityDefinition> getSecondaryEntityDefinitionsOrEmpty() {
        Collection primary = this.getPrimaryEntityDefinitions();
        if (primary.isEmpty()) {
            return new ArrayList<EntityDefinition>(0);
        }
        return this.getSecondaryEntityDefinitions();
    }

    @ModelAttribute(value="_notes")
    public List<NotePojo> getNotes(Locale locale) {
        return this.noteRepository.findAllDisplayed().stream().map(n -> new NotePojo(n, this.initService.getlocaleCodeForLocale(locale))).toList();
    }

    @ModelAttribute(value="_draftCount")
    public long getDraftCount() {
        return this.entityRepository.countLatestByCriteria(Criteria.where((String)"draft").is((Object)true).and("userUniqueId").is((Object)this.authInfoHelper.getUserId()));
    }

    @ModelAttribute(value="systemEntityDefinitions")
    public Collection<EntityDefinition> getSystemEntityDefinitions() {
        return this.entityDefinitionRepository.findAllLatest().stream().filter(ed -> ed.isSystem()).toList();
    }

    @ModelAttribute(value="vocabularyDefinitions")
    public Collection<VocabularyDefinition> getVocabularyDefinitions() {
        return this.vocabularyDefinitionRepository.findAllLatest().stream().filter(ed -> !ed.isSystem()).toList();
    }

    @ModelAttribute(value="systemVocabularyDefinitions")
    public Collection<VocabularyDefinition> getSystemVocabularyDefinitions() {
        return this.vocabularyDefinitionRepository.findAllLatest().stream().filter(ed -> ed.isSystem()).toList();
    }

    public BaseViewController(String mainNavId) {
        super(mainNavId);
    }

    @ExceptionHandler(value={NotFoundException.class})
    public String handleRuntimeException(Model model, HttpServletResponse resp, HttpServletRequest req, NotFoundException ex, Locale locale) {
        resp.setStatus(ex.getStatus().value());
        String message = ex.getMessage();
        model.addAttribute("status", (Object)ex.getStatus());
        model.addAttribute("message", (Object)message);
        model.addAttribute("_auth", (Object)this.authInfoHelper.getAuth());
        return "error";
    }

    protected Collection<EntityDefinition> getPrimaryEntityDefinitions() {
        return this.entityDefinitionRepository.findLatestByCriteria((CriteriaDefinition)Criteria.where((String)"primary").is((Object)true).and("system").is((Object)false));
    }

    protected Collection<EntityDefinition> getSecondaryEntityDefinitions() {
        Criteria c = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"system").is((Object)false), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"primary").exists(false), Criteria.where((String)"primary").is((Object)false)})});
        return this.entityDefinitionRepository.findLatestByCriteria((CriteriaDefinition)c);
    }
}

