/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.service;

import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import de.uniba.minf.registry.service.EntityDefinitionService;
import de.uniba.minf.registry.view.helper.EntityRelationsHelper;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityDefinitionServiceImpl
implements EntityDefinitionService {
    @Autowired
    private EntityDefinitionRepository entityDefRepo;
    @Autowired
    private EntityRelationsHelper entityRelationsHelper;

    public Collection<EntityDefinition> findAllCurrent() {
        return this.entityDefRepo.findAllLatest();
    }

    public EntityDefinition findCurrentByName(String name) {
        return this.findCurrentByName(name, false);
    }

    public EntityDefinition findCurrentByName(String name, boolean appendRelations) {
        EntityDefinition ed = this.entityDefRepo.findCurrentByName(name);
        if (ed != null && appendRelations) {
            this.entityRelationsHelper.appendRelationsPropertyDefinitionBlock(ed);
        }
        return ed;
    }

    public EntityDefinition findByNameAndVersion(String name, long version, boolean appendRelations) {
        EntityDefinition ed = this.entityDefRepo.findByNameAndVersion(name, version);
        if (ed != null && appendRelations) {
            this.entityRelationsHelper.appendRelationsPropertyDefinitionBlock(ed);
        }
        return ed;
    }

    public EntityDefinition findByNameAndVersion(String name, long version) {
        return this.entityDefRepo.findByNameAndVersion(name, version);
    }
}

