/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.repository;

import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.repository.EntityDefinitionRepositoryCustom;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class EntityDefinitionRepositoryCustomImpl
implements EntityDefinitionRepositoryCustom {
    @Autowired
    private MongoTemplate mongoTemplate;

    public EntityDefinition findCurrentByName(String name) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"name").is((Object)name));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"creationInstant"}));
        return (EntityDefinition)this.mongoTemplate.findOne(query, EntityDefinition.class);
    }

    public EntityDefinition findByNameAndVersion(String name, long version) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"name").is((Object)name));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        return (EntityDefinition)this.mongoTemplate.findOne(query, EntityDefinition.class);
    }

    public List<String> findAllDefinitionNames() {
        return this.mongoTemplate.findDistinct("name", EntityDefinition.class, String.class);
    }

    public Collection<EntityDefinition> findAllLatest() {
        return this.findLatestByCriteria(null);
    }

    public Collection<EntityDefinition> findLatestByCriteria(CriteriaDefinition criteria) {
        Query query = new Query();
        if (criteria != null) {
            query.addCriteria(criteria);
        }
        query.with(Sort.by((String[])new String[]{"name"}).ascending());
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"nextVersionUniqueId").isNull());
        return this.mongoTemplate.find(query, EntityDefinition.class);
    }

    public List<String> findAllDefinitionNames(boolean includeSystem) {
        if (includeSystem) {
            return this.findAllDefinitionNames();
        }
        return this.mongoTemplate.findDistinct(Query.query((CriteriaDefinition)Criteria.where((String)"system").is((Object)false)), "name", EntityDefinition.class, String.class);
    }
}

