/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.profiles;

import de.uniba.minf.auth.ProfileActionHandler;
import de.uniba.minf.auth.profile.AuthProfile;
import de.uniba.minf.registry.model.PersistedUser;
import de.uniba.minf.registry.model.UserGroup;
import de.uniba.minf.registry.model.UserGroupAssignment;
import de.uniba.minf.registry.repository.UserGroupRepository;
import de.uniba.minf.registry.repository.UserRepository;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UserProfileActionHandler
implements ProfileActionHandler {
    private static final Logger log = LoggerFactory.getLogger(UserProfileActionHandler.class);
    @Autowired
    private UserRepository userRepo;
    @Autowired
    private UserGroupRepository userGroupRepo;

    public void handleLogin(AuthProfile profile) {
        PersistedUser u;
        Optional optU = this.userRepo.findByIssuerAndUsername(profile.getIssuer(), profile.getUsername());
        boolean newUser = false;
        if (optU.isPresent()) {
            u = (PersistedUser)optU.get();
            profile.addAttribute("first_name", (Object)u.getFirstName());
            profile.addAttribute("family_name", (Object)u.getLastName());
            if (profile.getEmail() != null && !profile.getEmail().isBlank()) {
                u.setEmail(profile.getEmail());
                u.setEmailProtected(true);
            } else {
                profile.addAttribute("email", (Object)u.getEmail());
            }
        } else {
            u = new PersistedUser(profile);
            newUser = true;
        }
        u.setLastLogin(LocalDateTime.now());
        this.userRepo.save((Object)u);
        if (newUser) {
            List groups = this.userGroupRepo.findUnassignedByUsername(u.getUsername());
            for (UserGroup g : groups) {
                for (UserGroupAssignment ga : g.getUserGroupAssignments()) {
                    if (!ga.getUsername().equals(u.getUsername()) || ga.getUserUniqueId() != null) continue;
                    ga.setUserUniqueId(u.getUniqueId());
                }
                this.userGroupRepo.save((Object)g);
                log.info("User group [{}] updated pending user assignment to uniqueId {}", (Object)g.getUniqueId(), (Object)u.getUniqueId());
            }
        }
        profile.setId(u.getUniqueId());
        log.debug("User has logged in: {}=>{}", (Object)profile.getId(), (Object)u.getUniqueId());
    }

    public void handleLogout(AuthProfile profile) {
        log.debug("User has logged out: {}", (Object)profile.getId());
    }
}

