/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.pojo;

import de.uniba.minf.registry.model.Note;
import java.time.LocalDate;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

public class NotePojo {
    public static final Parser markdownParser = Parser.builder().build();
    public static final HtmlRenderer renderer = HtmlRenderer.builder().build();
    private LocalDate localDate;
    private String localizedText;

    public NotePojo(Note note, String localeCode) {
        this.setLocalDate(note.getLocalDisplayDate());
        String text = localeCode != null && note.getLocalizedTexts().containsKey(localeCode) ? (String)note.getLocalizedTexts().get(localeCode) : (String)note.getLocalizedTexts().values().stream().findFirst().orElse(null);
        Node document = markdownParser.parse(text);
        this.setLocalizedText(renderer.render(document));
    }

    public LocalDate getLocalDate() {
        return this.localDate;
    }

    public String getLocalizedText() {
        return this.localizedText;
    }

    public void setLocalDate(LocalDate localDate) {
        this.localDate = localDate;
    }

    public void setLocalizedText(String localizedText) {
        this.localizedText = localizedText;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotePojo)) {
            return false;
        }
        NotePojo other = (NotePojo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LocalDate this$localDate = this.getLocalDate();
        LocalDate other$localDate = other.getLocalDate();
        if (this$localDate == null ? other$localDate != null : !((Object)this$localDate).equals(other$localDate)) {
            return false;
        }
        String this$localizedText = this.getLocalizedText();
        String other$localizedText = other.getLocalizedText();
        return !(this$localizedText == null ? other$localizedText != null : !this$localizedText.equals(other$localizedText));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotePojo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $localDate = this.getLocalDate();
        result = result * 59 + ($localDate == null ? 43 : ((Object)$localDate).hashCode());
        String $localizedText = this.getLocalizedText();
        result = result * 59 + ($localizedText == null ? 43 : $localizedText.hashCode());
        return result;
    }

    public String toString() {
        return "NotePojo(localDate=" + this.getLocalDate() + ", localizedText=" + this.getLocalizedText() + ")";
    }
}

