/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import de.uniba.minf.registry.RegistryConstants;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.serialization.base.BasePropertyListDeserializer;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityDeserializer
extends BasePropertyListDeserializer<Entity, EntityDefinition> {
    private static final long serialVersionUID = 5519790693725478035L;
    @Autowired
    private EntityDefinitionRepository entityDefinitionRepository;

    public EntityDeserializer() {
        this(null);
    }

    public EntityDeserializer(Class<?> c) {
        super(c);
    }

    protected Entity createObject(JsonNode node) {
        Entity entity = new Entity();
        if (node.has("definition_name")) {
            entity.setDefinitionName(node.get("definition_name").asText());
        }
        if (node.has("definition_version")) {
            entity.setDefinitionVersion(node.get("definition_version").asLong());
        }
        for (String idVariant : RegistryConstants.SERIALIZATION_EXTERNAL_IDENTIFIER_VARIANTS) {
            if (!node.has(idVariant)) continue;
            entity.setExternalIdentifier(node.get(idVariant).asText());
            break;
        }
        return entity;
    }

    protected EntityDefinition getDefinition(Entity entity) {
        return this.entityDefinitionRepository.findCurrentByName(entity.getDefinitionName());
    }
}

