/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.serialization.base.BaseDefinitionSerializer;
import java.io.IOException;
import java.util.Map;

public class EntityDefinitionSerializer
extends BaseDefinitionSerializer<EntityDefinition> {
    private static final long serialVersionUID = -4479783538703957404L;

    public EntityDefinitionSerializer() {
        this(null);
    }

    public EntityDefinitionSerializer(Class<EntityDefinition> c) {
        super(c);
    }

    public void serialize(EntityDefinition value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("entity", value.getName());
        this.writeTrueField("primary", value.isPrimary(), gen);
        this.writeTrueField("compositing", value.isCompositing(), gen);
        this.writeTrueField("localCreation", value.isLocalCreation(), gen);
        if (value.getPresentationProperties() != null && !value.getPresentationProperties().isEmpty()) {
            gen.writeObjectFieldStart("presentation");
            for (Map.Entry e : value.getPresentationProperties().entrySet()) {
                this.writeStringField((String)e.getKey(), (String)e.getValue(), gen);
            }
            gen.writeEndObject();
        }
        super.serialize((BaseDefinition)value, gen, provider);
        gen.writeEndObject();
    }
}

