/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.migration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.uniba.minf.registry.migration.MigrationAction;
import de.uniba.minf.registry.model.VersionInfo;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import de.uniba.minf.registry.repository.VersionInfoRepository;
import de.uniba.minf.registry.service.EntityService;
import de.unibamberg.minf.core.web.exception.ApplicationSetupException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.tika.Tika;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;

@Component
public class MigrationServiceImpl
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MigrationServiceImpl.class);
    private static final String VERSION_HASH_PREFIX = "Registry";
    @Value(value="${paths.backups:#{null}}")
    private String backupsPath;
    @Value(value="${paths.definitions:#{null}}")
    private String customDefinitions;
    @Value(value="${paths.entries:#{null}}")
    private String customEntries;
    @Autowired
    ResourceLoader resourceLoader;
    @Autowired
    @Qualifier(value="yamlMapper")
    private ObjectMapper yamlMapper;
    @Autowired
    @Qualifier(value="jsonMapper")
    private ObjectMapper jsonMapper;
    @Autowired
    private Tika tika;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private VersionInfoRepository versionInfoRepository;
    @Autowired
    private EntityService entityService;
    private final MessageDigest md = MessageDigest.getInstance("MD5");

    public void afterPropertiesSet() throws Exception {
        ArrayList<String> versions = new ArrayList<String>();
        List versionInfos = this.versionInfoRepository.findAll();
        for (VersionInfo vi : versionInfos) {
            if (!vi.getVersionHash().equals(new String(this.md.digest(new String(VERSION_HASH_PREFIX + vi.getVersion()).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8))) {
                log.error("Cancelling migration checks: failed to compare version hashes. Is the correct database configured?");
                return;
            }
            versions.add(vi.getVersion());
        }
        this.performMigrations(versions);
    }

    private void performMigrations(List<String> existingVersions) throws Exception {
        boolean backedUp;
        backedUp |= this.migrate(existingVersions, !(backedUp |= this.migrate(existingVersions, !(backedUp |= this.migrate(existingVersions, !(backedUp |= this.migrate(existingVersions, !(backedUp |= this.migrate(existingVersions, !(backedUp = false), "5.0", arg_0 -> this.importSystemDefinitionsAndEntriesForVersion(arg_0))), "5.1", arg_0 -> this.importSystemDefinitionsAndEntriesForVersion(arg_0))), "5.2", arg_0 -> this.setLocalCreationDefaults(arg_0))), "5.3", arg_0 -> this.refreshRelatedEntityCache(arg_0))), "5.4", arg_0 -> this.importSystemDefinitionsAndEntriesForVersion(arg_0));
        log.info("Migration performed: {}", (Object)(backedUp |= this.importConfiguredDefinitionsAndEntries()));
    }

    private boolean importSystemDefinitionsAndEntriesForVersion(String version) {
        try {
            Resource[] resources;
            for (Resource resource : resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources("classpath:system_definitions/" + version + "*")) {
                this.handleResource(resource, true);
            }
            for (Resource resource : resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources("classpath:system_entries/" + version + "*")) {
                this.handleResource(resource, false);
            }
        }
        catch (ApplicationSetupException | IOException ex) {
            log.error("Failed to import system definitions and entries", ex);
            return false;
        }
        return true;
    }

    private boolean importConfiguredDefinitionsAndEntries() {
        try {
            File f;
            if (this.customDefinitions != null && (f = new File(this.customDefinitions)).exists()) {
                this.scanHandleAndDeleteFiles(f, true);
            }
            if (this.customEntries != null && (f = new File(this.customEntries)).exists()) {
                this.scanHandleAndDeleteFiles(f, false);
            }
        }
        catch (ApplicationSetupException | IOException e) {
            log.error("Failed to import configured system definitions and entries", e);
            return false;
        }
        return true;
    }

    private boolean setLocalCreationDefaults(String version) {
        this.mongoTemplate.update(EntityDefinition.class).matching((CriteriaDefinition)Criteria.where((String)"nextVersionUniqueId").isNull()).apply((UpdateDefinition)new Update().set("localCreation", (Object)true)).all();
        return true;
    }

    private boolean refreshRelatedEntityCache(String version) {
        this.entityService.refreshRelatedEntityCache();
        return true;
    }

    private void scanHandleAndDeleteFiles(File f, boolean definitions) throws IOException, ApplicationSetupException {
        if (f.isDirectory()) {
            for (File file : f.listFiles()) {
                this.handleResource(this.resourceLoader.getResource("file:" + file.getAbsolutePath()), definitions);
                FileUtils.delete((File)file);
            }
        } else {
            this.handleResource(this.resourceLoader.getResource("file:" + f.getAbsolutePath()), definitions);
            FileUtils.delete((File)f);
        }
    }

    private void handleResource(Resource r, boolean definitions) throws IOException, ApplicationSetupException {
        String mimeType = this.detectMimeType(r);
        log.info("Importing {} from {} ({})", new Object[]{definitions ? "definition" : "entries", r.getFilename(), mimeType});
        ObjectMapper mapper = this.getMapperForMimeType(mimeType);
        try (InputStream stream = r.getInputStream();){
            JsonNode n = mapper.readTree(stream);
            if (n.isArray()) {
                for (JsonNode entry : n) {
                    this.handleNode(mapper, entry, definitions);
                }
            } else {
                this.handleNode(mapper, n, definitions);
            }
        }
    }

    private String detectMimeType(Resource r) throws IOException {
        try (TikaInputStream stream = TikaInputStream.get((InputStream)r.getInputStream());){
            Metadata metadata = new Metadata();
            metadata.set("resourceName", r.getFilename());
            String string = this.tika.detect((InputStream)stream, metadata);
            return string;
        }
    }

    private ObjectMapper getMapperForMimeType(String mimeType) throws ApplicationSetupException {
        if (mimeType != null && (mimeType.endsWith("/x-yaml") || mimeType.endsWith("/yaml"))) {
            return this.yamlMapper;
        }
        if (mimeType != null && mimeType.endsWith("/json")) {
            return this.jsonMapper;
        }
        throw new ApplicationSetupException("Failed to initialize definitions or entries: unsupported MIME type: " + (mimeType == null ? "NULL" : mimeType), this.getClass());
    }

    private void handleNode(ObjectMapper mapper, JsonNode n, boolean definitions) throws JsonProcessingException, IllegalArgumentException {
        if (definitions && n.has("entity")) {
            this.mongoTemplate.save((Object)((EntityDefinition)mapper.treeToValue((TreeNode)n, EntityDefinition.class)));
        } else if (definitions && n.has("vocabulary")) {
            this.mongoTemplate.save((Object)((VocabularyDefinition)mapper.treeToValue((TreeNode)n, VocabularyDefinition.class)));
        } else if (!definitions && n.has("_vocabulary")) {
            VocabularyEntry ve = (VocabularyEntry)mapper.treeToValue((TreeNode)n, VocabularyEntry.class);
            Query q = new Query();
            q.addCriteria((CriteriaDefinition)Criteria.where((String)"key").is((Object)ve.getKey()).and("definitionName").is((Object)ve.getDefinitionName()));
            VocabularyEntry eExist = (VocabularyEntry)this.mongoTemplate.findOne(q, VocabularyEntry.class);
            if (eExist != null) {
                ve.setUniqueId(eExist.getUniqueId());
            }
            this.mongoTemplate.save((Object)ve);
        } else {
            this.mongoTemplate.save((Object)((Entity)mapper.treeToValue((TreeNode)n, Entity.class)));
        }
    }

    private boolean migrate(List<String> existingVersions, boolean backup, String version, MigrationAction migration) throws Exception {
        if (!existingVersions.contains(version)) {
            log.info("Migrating to version [{}]", (Object)version);
            if (backup) {
                this.backupDb();
            }
            boolean success = migration.migrate(version);
            this.saveVersionInfo(version, success);
            log.info("Migration to version [{}] performed {}", (Object)version, (Object)(success ? "sucessfully" : "WITH ERRORS"));
            return true;
        }
        return false;
    }

    private void backupDb() throws Exception {
        if (this.backupsPath == null) {
            log.warn("No path for backups (paths.backups) configured; skipping backup creation before applying migration");
            return;
        }
        String backupPath = this.backupsPath + File.separator + DateTime.now().toString(DateTimeFormat.forPattern((String)"yyyyMMdd_HHmmss"));
        Files.createDirectories(Paths.get(new File(backupPath).toURI()), new FileAttribute[0]);
        try {
            Runtime.getRuntime().exec(String.format("mongodump --out %s --db %s", backupPath, this.mongoTemplate.getDb().getName()));
            log.info("Backed up database {} to [{}]", (Object)this.mongoTemplate.getDb().getName(), (Object)backupPath);
        }
        catch (Exception e) {
            log.error("Failed to create mongodb backup", (Throwable)e);
            throw e;
        }
    }

    private void saveVersionInfo(String version, boolean success) {
        VersionInfo vi = new VersionInfo();
        vi.setUpdateWithErrors(!success);
        vi.setVersion(version);
        vi.setVersionHash(new String(this.md.digest(new String(VERSION_HASH_PREFIX + vi.getVersion()).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
        this.versionInfoRepository.save((Object)vi);
    }
}

