/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.controller.user;

import de.uniba.minf.auth.spring.mvc.AuthInfoHelper;
import de.uniba.minf.auth.spring.mvc.model.AuthPojo;
import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.exception.ApiInsufficientPermissionsException;
import de.uniba.minf.core.rest.exception.ApiItemNotFoundException;
import de.uniba.minf.registry.model.PersistedUser;
import de.uniba.minf.registry.repository.UserRepository;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseUserRestController
extends BaseRestController {
    @Autowired
    protected UserRepository userRepo;
    @Autowired
    protected AuthInfoHelper authInfoHelper;

    protected BaseUserRestController(String relativeBase) {
        super(relativeBase);
    }

    protected PersistedUser checkCanAccessUser(AuthPojo authPojo, String reqUniqueId) throws ApiItemNotFoundException, ApiInsufficientPermissionsException {
        if (reqUniqueId == null) {
            throw new ApiItemNotFoundException(reqUniqueId, "user");
        }
        if (authPojo.getUserId() == null || authPojo.getLevel() < 100 && !authPojo.getUserId().equals(reqUniqueId)) {
            throw new ApiInsufficientPermissionsException();
        }
        Optional reqUser = this.userRepo.findById((Object)reqUniqueId);
        if (!reqUser.isPresent()) {
            throw new ApiItemNotFoundException(reqUniqueId, "user");
        }
        return (PersistedUser)reqUser.get();
    }
}

