/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.config.db;

import de.uniba.minf.auth.spring.mvc.AuthInfoHelper;
import de.uniba.minf.registry.model.entity.EntityRelation;
import java.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Configuration
public class EntityRelationEventListener
extends AbstractMongoEventListener<EntityRelation> {
    @Autowired
    private AuthInfoHelper authinfoHelper;

    public void onBeforeConvert(BeforeConvertEvent<EntityRelation> event) {
        super.onBeforeConvert(event);
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        String userUniqueId = attrs != null ? this.authinfoHelper.getAuth().getUserId() : "_system";
        EntityRelation obj = (EntityRelation)event.getSource();
        obj.setCreationInstant(Instant.now());
        obj.setUserUniqueId(userUniqueId);
    }
}

