package de.uniba.minf.registry.view.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;

import lombok.Data;

@Data
public class PropertyBlockViewItem {
	private String name;
	private String identifier;
	private String messageCode;
	private List<PropertyViewItem> propertyViewItems;
	
	public String getUrlSafeLabel() {
		if (name==null) {
			return null;
		}
		return URLEncoder.encode(name, StandardCharsets.UTF_8);
	}
}
