package de.uniba.minf.registry.view.debug;

import org.springframework.stereotype.Component;
import org.thymeleaf.context.WebEngineContext;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
public class ModelDumper {

	/* <div th:text="${_modelDumper.dumpToLog(#vars)}"/> */
    public void dumpToLog(WebEngineContext ctx) {
        log.debug("Model: {}", formatAsJson(ctx));
    }

	private Object formatAsJson(WebEngineContext ctx) {
		StringBuilder bldr = new StringBuilder();
		bldr.append("{\n}");
		ctx.getVariableNames().stream()
			.forEach(n -> bldr
					.append("\t\"")
					.append(n)
					.append("\": \"")
					.append(ctx.getVariable(n))
					.append("\"\n"));
		
		bldr.append("}");
		return bldr.toString();
	}
}