package de.uniba.minf.registry.view.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.ImportRepository;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.pojo.ImportPojo;
import de.uniba.minf.registry.pojo.converter.ImportConverter;
import de.unibamberg.minf.core.web.controller.ResourceNotFoundException;
import jakarta.servlet.http.HttpServletResponse;

@Controller
@RequestMapping("/imports")
public class ImportViewController extends BaseViewController {
	@Autowired private ImportRepository importRepo;
	@Autowired private ImportConverter importConverter;
	@Autowired private EntityRepository entityRepo;
	
	public ImportViewController() {
		super("imports");
	}
	
	@GetMapping
	public String listImports(HttpServletResponse response) throws IOException  {
        return "imports/list";
	}
	
	@GetMapping("/{importId}/entities/")
    public String showEntitiesForImport(@PathVariable("importId") String importId, Model model, Locale locale) {
    	Optional<ImportPojo> i = importConverter.convertPojo(importRepo.findById(importId));
		if (i.isEmpty()) {
    		throw new ResourceNotFoundException();
    	}
		model.addAttribute("import", i.get());

        return "imports/list_entities";
    }
	
	@GetMapping("/import")
	public String importDialog(Model model, HttpServletResponse response) throws IOException  {
		model.addAttribute("templates", entityRepo.findLatestByCriteria(Criteria.where("template").is(true)));
		
		List<EntityDefinition> entityDefinitions = new ArrayList<>();
		entityDefinitions.addAll(this.getPrimaryEntityDefinitions());
		entityDefinitions.addAll(this.getSecondaryEntityDefinitions());
		model.addAttribute("entityDefinitions", entityDefinitions);
		
        return "imports/import";
	}
}
