package de.uniba.minf.registry.view.controller;

import java.util.Locale;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.pojo.EntityDefinitionPojo;
import de.uniba.minf.registry.pojo.converter.EntityDefinitionConverter;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import de.uniba.minf.registry.repository.EntityRepository;
import de.unibamberg.minf.core.web.controller.ResourceNotFoundException;


@Controller
@RequestMapping("/entityDefinitions")
public class EntityDefinitionViewController extends BaseViewController {
	@Autowired private EntityDefinitionRepository entityDefinitionRepo;
	@Autowired private EntityDefinitionConverter entityDefinitionConverter;
	
	@Autowired private EntityRepository entityRepo;
	
	@Autowired @Qualifier("yamlMapper") private ObjectMapper yamlMapper;
	@Autowired @Qualifier("jsonMapper") private ObjectMapper jsonMapper;

	public EntityDefinitionViewController() {
		super("entityDefinitions");
	}

	@GetMapping
    public String listDefinitions(Model model, Locale locale) {
    	model.addAttribute("apiUrlPrefix", "def/entities");
    	model.addAttribute("definitionType", "entityDefinitions");
        return "definitions/list";
    }
	
	@GetMapping("/{definition}/")
    public String showDefinition(@PathVariable("definition") String definition, Model model, Locale locale) throws JsonProcessingException {		
    	Optional<EntityDefinition> d = Optional.ofNullable(entityDefinitionRepo.findCurrentByName(definition));
		if (d.isEmpty()) {
    		throw new ResourceNotFoundException();
    	}
		EntityDefinitionPojo p = entityDefinitionConverter.convertPojo(d.get());
		p.setEntryCount(entityRepo.countByDefinition(definition, authInfoHelper.getAuth().isAuth()));
		
		model.addAttribute("def", p);
		model.addAttribute("definitionType", "entityDefinitions");
		model.addAttribute("jsonDatamodel", jsonMapper.writeValueAsString(d.get()));
		model.addAttribute("yamlDatamodel", yamlMapper.writeValueAsString(d.get()));
        return "definitions/definition";
    }
}