package de.uniba.minf.registry.view.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;

import de.uniba.minf.auth.spring.mvc.AuthInfoHelper;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.VocabularyDefinitionRepository;
import de.uniba.minf.registry.service.EntityDefinitionService;
import de.unibamberg.minf.core.web.controller.BaseTranslationController;
import de.unibamberg.minf.core.web.exception.NotFoundException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class BaseViewController extends BaseTranslationController {
	@Autowired protected EntityDefinitionService entityDefinitionService;
	@Autowired protected EntityDefinitionRepository entityDefinitionRepository;
	@Autowired protected EntityRepository entityRepository;
	@Autowired protected VocabularyDefinitionRepository vocabularyDefinitionRepository;
	
	@Autowired protected AuthInfoHelper authInfoHelper;
	
	@Value("${baseUrl}")
	protected String baseUrl;
	
	@ModelAttribute("primaryEntityDefinitions")
	public Collection<EntityDefinition> getPrimaryEntityDefinitionsOrAll() {
		Collection<EntityDefinition> primary = this.getPrimaryEntityDefinitions();
		if (primary.isEmpty()) {
			primary = this.getSecondaryEntityDefinitions();
		}
		return primary;
	}
	
	@ModelAttribute("secondaryEntityDefinitions")
	public Collection<EntityDefinition> getSecondaryEntityDefinitionsOrEmpty() {
		Collection<EntityDefinition> primary = this.getPrimaryEntityDefinitions();
		if (primary.isEmpty()) {
			return new ArrayList<>(0);
		} else {
			return this.getSecondaryEntityDefinitions();
		}
	}
	
	@ModelAttribute("_draftCount")
	public long getDraftCount() {
		return entityRepository.countLatestByCriteria(Criteria.where("draft").is(true).and("userUniqueId").is(authInfoHelper.getUserId()));
	}
	
	@ModelAttribute("systemEntityDefinitions")
	public Collection<EntityDefinition> getSystemEntityDefinitions() {
		return entityDefinitionRepository.findAllLatest().stream().filter(ed -> ed.isSystem()).toList();
	}
	
	@ModelAttribute("vocabularyDefinitions")
	public Collection<VocabularyDefinition> getVocabularyDefinitions() {
		return vocabularyDefinitionRepository.findAllLatest().stream().filter(ed -> !ed.isSystem()).toList();
	}
	
	@ModelAttribute("systemVocabularyDefinitions")
	public Collection<VocabularyDefinition> getSystemVocabularyDefinitions() {
		return vocabularyDefinitionRepository.findAllLatest().stream().filter(ed -> ed.isSystem()).toList();
	}
		
	public BaseViewController(String mainNavId) {
		super(mainNavId);
	}
	
	@ExceptionHandler(NotFoundException.class)
	public String handleRuntimeException(Model model, HttpServletResponse resp, HttpServletRequest req, NotFoundException ex, Locale locale) {
		resp.setStatus(ex.getStatus().value());
		String message = ex.getMessage();
		
		model.addAttribute("status", ex.getStatus());
		model.addAttribute("message", message);
		
		model.addAttribute("_auth", authInfoHelper.getAuth());
		
		return "error";
	}
	
	protected Collection<EntityDefinition> getPrimaryEntityDefinitions() {
		return entityDefinitionRepository.findLatestByCriteria(Criteria.where("primary").is(true).and("system").is(false));
	}
	
	protected Collection<EntityDefinition> getSecondaryEntityDefinitions() {
		Criteria c = new Criteria().andOperator(Criteria.where("system").is(false), new Criteria().orOperator(Criteria.where("primary").exists(false), Criteria.where("primary").is(false)));
    	return entityDefinitionRepository.findLatestByCriteria(c);
	}
}
