package de.uniba.minf.registry.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.data.mongodb.repository.Query;

import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;

public interface VocabularyEntryRepositoryCustom {
	public long countByDefinition(String definition);
	public List<VocabularyEntry> findByDefinition(String definition);
	public List<VocabularyEntry> findByDefinitionAndQuery(String name, String query);
	public void saveOrUpdate(VocabularyEntry e);
	public void saveOrUpdateAll(List<VocabularyEntry> vocabularyEntries);
	
	public void deleteByVocabularyName(String name);
}