package de.uniba.minf.registry.repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;

public class VocabularyDefinitionRepositoryCustomImpl implements VocabularyDefinitionRepositoryCustom {
	@Autowired private MongoTemplate mongoTemplate;
	
	@Override
	public List<String> findAllDefinitionNames() {
		return mongoTemplate.findDistinct("name", VocabularyDefinition.class, String.class);
	}
	
	@Override
	public Collection<VocabularyDefinition> findAllLatest() {
		return findLatestByCriteria(null);
	}
	
	@Override
	public VocabularyDefinition findCurrentByName(String name) {
		final Query query = new Query();
		query.addCriteria(Criteria.where("name").is(name));
		query.with(Sort.by(Sort.Direction.DESC, "creationInstant"));
		
		return mongoTemplate.findOne(query, VocabularyDefinition.class);		
	}
	
	@Override
	public Collection<VocabularyDefinition> findLatestByCriteria(CriteriaDefinition criteria) {
		final Query query = new Query();
		if (criteria!=null) {
			query.addCriteria(criteria);
		}
		query.with(Sort.by(Sort.Direction.DESC, "creationInstant"));
		Map<String, VocabularyDefinition> result = new HashMap<>();
		mongoTemplate.find(query, VocabularyDefinition.class).stream().forEach(e -> {
			if (!result.containsKey(e.getName())) {
				result.put(e.getName(), e);
			}
		});
		return result.values();
	}
}