package de.uniba.minf.registry.repository;

import java.util.Collection;
import java.util.List;
import java.util.Optional;

import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;

import de.uniba.minf.registry.model.entity.Entity;

public interface EntityRepositoryCustom {
	public Optional<Entity> findLatestByEntityId(String entityId);
	public Collection<Entity> findLatestByEntityIds(List<String> entityIds);
	public Optional<Entity> findEarliestByEntityId(String entityId);
	public long countVersionsByEntityId(String entityId);
	public Collection<Entity> findAllLatest(boolean includeDrafts);
	public Collection<Entity> findLatestByDefinition(String definition, boolean includeDrafts);
	public Collection<Entity> findLatestByCriteria(CriteriaDefinition criteria);
	public Collection<Entity> findLatestByDefinitionAndQuery(String name, String query);
	public long countByDefinition(String definition, boolean includeDrafts);
	public String findDefinitionNameById(String uniqueId);
	public boolean getIsLatest(String uniqueId);
	public long countByImportId(String uniqueId);
	public Collection<Entity> findByImportId(String importId);
	public long removeImportIdByImportId(String importId);
	public long countLatestByCriteria(Criteria criteria);
}
