package de.uniba.minf.registry.pojo.converter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.pojo.VocabularyDefinitionPojo;
import de.uniba.minf.registry.pojo.converter.base.BaseDefinitionConverter;
import de.uniba.minf.registry.repository.VocabularyEntryRepository;

@Component
public class VocabularyDefinitionConverter extends BaseDefinitionConverter<VocabularyDefinition, VocabularyDefinitionPojo> {
	@Autowired private VocabularyEntryRepository entryRepo;

	@Override
	public VocabularyDefinitionPojo convertPojo(VocabularyDefinition ed) {
		VocabularyDefinitionPojo p = super.convertPojo(ed);
		p.setEntryCount(entryRepo.countByDefinition(ed.getName()));
		
		return p;
	}
	
	@Override
	protected VocabularyDefinitionPojo createPojo() {
		return new VocabularyDefinitionPojo();
	}
}
