package de.uniba.minf.registry.pojo.converter;

import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import de.uniba.minf.registry.model.Import;
import de.uniba.minf.registry.model.PersistedUser;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.pojo.ImportPojo;
import de.uniba.minf.registry.pojo.converter.base.BaseConverter;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.UserRepository;

@Component
public class ImportConverter extends BaseConverter<Import, ImportPojo> {
	@Autowired private UserRepository userRepo;
	@Autowired private EntityRepository entityRepo;
	
	@Override
	public ImportPojo convertPojo(Import i) {
		ImportPojo p = new ImportPojo();
		p.setUniqueId(i.getUniqueId());
		p.setCreationInstant(i.getCreationInstant());	
		p.setUserId(i.getUserUniqueId());
		if (i.getUserUniqueId()!=null) {
			Optional<PersistedUser> u = userRepo.findById(i.getUserUniqueId());
			if (u.isPresent()) {
				p.setUsername(u.get().getUsername());
			}
		}
		p.setTemplateId(i.getTemplateId());
		if (i.getTemplateId()!=null) {
			Optional<Entity> e = entityRepo.findLatestByEntityId(i.getTemplateId());
			if (e.isPresent()) {
				p.setTemplate(e.get().getDefinitionName() + ": " + i.getTemplateId());
			}
		}
		
		p.setCount(entityRepo.countByImportId(i.getUniqueId()));
		
		return p;
	}
}
