package de.uniba.minf.registry.pojo.converter;

import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import de.uniba.minf.registry.model.PersistedUser;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.pojo.EntityPojo;
import de.uniba.minf.registry.pojo.converter.base.BaseConverter;
import de.uniba.minf.registry.repository.UserRepository;

@Component
public class EntityConverter extends BaseConverter<Entity, EntityPojo> {
	@Autowired private UserRepository userRepo;

	@Override
	public EntityPojo convertPojo(Entity i) {
		EntityPojo p = new EntityPojo();
		p.setUniqueId(i.getUniqueId());
		p.setCreationInstant(i.getCreationInstant());
		p.setReadOnly(i.isReadOnly());		
		p.setEntityId(i.getEntityId());
		p.setNextVersionUniqueId(i.getNextVersionUniqueId());
		p.setValid(i.isValid());
		p.setDraft(i.isDraft());
		p.setTemplate(i.isTemplate());
		p.setHasProperties(i.getProperties()!=null && !i.getProperties().isEmpty());
		p.setDefinitionName(i.getDefinitionName());
		p.setDefinitionVersion(i.getDefinitionVersion());
		p.setImportId(i.getImportId());
		
		p.setUserId(i.getUserUniqueId());
		if (i.getUserUniqueId()!=null) {
			Optional<PersistedUser> u = userRepo.findById(i.getUserUniqueId());
			if (u.isPresent()) {
				p.setUsername(u.get().getUsername());
			}
		}
		
		return p;
	}
}
