package de.uniba.minf.registry.pojo;

import java.time.Instant;

import de.uniba.minf.core.rest.model.Identifiable;
import lombok.Data;

@Data
public class UserGroupAssignmentPojo implements Identifiable {
	private static final long serialVersionUID = -6436260180765554396L;
	
	private String uniqueId;
	private String name;

	private boolean currentUserCanEdit;
	
	private String assignmentUniqueId;
	private String userUniqueId;
	private String username;
	private boolean writeAccess;
	private boolean owner;
	private Instant expiration;
	private String expirationString;
	
	public boolean isPending() {
		return userUniqueId==null;
	}
	
	public boolean isExpiring() {
		return expiration!=null;
	}
	
	public boolean isExpired() {
		return expiration!=null && expiration.isBefore(Instant.now());
	}
}
