package de.uniba.minf.registry.model;

import org.springframework.data.annotation.Id;

import de.uniba.minf.core.rest.model.Identifiable;
import jakarta.validation.constraints.Pattern;
import lombok.Data;

@Data
public class VersionInfo implements Identifiable, Comparable<VersionInfo> {
	private static final long serialVersionUID = -6247839976852400057L;

	@Id
	private String uniqueId;
	
	@Pattern(regexp="^\\d+(\\.\\d+)?(\\.\\d+)?$")
	private String version;
	private String versionHash;
	private String note;
	private boolean updateWithErrors;
	
	@Override
	public int compareTo(VersionInfo oComp) {
		String[] versionArr = this.version.split("\\.");
		String[] compVersionArr = oComp.getVersion().split("\\.");
		
		for (int i=0; i<versionArr.length || i<compVersionArr.length; i++) {
			if (i==versionArr.length) {
				return -1;
			}
			if (i==compVersionArr.length) {
				return 1;
			}
			int majorMinorComp = Integer.valueOf(versionArr[i]).compareTo(Integer.valueOf(compVersionArr[i]));
			if (majorMinorComp!=0) {
				return majorMinorComp;
			}
		}
		return 0;
	}
}
