package de.uniba.minf.registry.model;

import java.time.Instant;
import java.time.LocalDateTime;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

import de.uniba.minf.core.rest.model.Identifiable;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.ToString;

@Data
@Document
@ToString(callSuper = true)
public class RegistryAccessToken implements Identifiable {

	private static final long serialVersionUID = -297453952968739067L;

	@Id
	private String id;
	
	private String uniqueId;
	
	private String name;
	
	private LocalDateTime expires;
	
	@NotNull
	@Indexed
	private String userId;
	
	private Instant creationInstant;

}
