package de.uniba.minf.registry.model;

import java.time.LocalDateTime;
import java.util.Collection;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import de.uniba.minf.auth.profile.AuthProfile;
import de.uniba.minf.core.rest.model.Identifiable;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Document
@NoArgsConstructor
public class PersistedUser implements Identifiable {
	private static final long serialVersionUID = -7470824585266674170L;
	
	@Id
	private String uniqueId;
	
	private Collection<String> authorities;
	
	private String issuer;
	private String username;
	private String linkedId;
	private boolean expired;
	
	private String email;
	private String firstName;
	private String lastName;
	
	private String language;
	private LocalDateTime lastLogin;
	
	public PersistedUser(AuthProfile profile) {
		if (profile!=null && profile.getId()!=null) {
			profile.setId(this.getUniqueId());
		}
		
		this.setIssuer(profile.getIssuer());
		this.setLinkedId(profile.getLinkedId());
		this.setAuthorities(profile.getRoles());
		this.setUsername(profile.getUsername());
		
		this.setEmail(profile.getEmail());
		this.setFirstName(profile.getFirstName());
		this.setLastName(profile.getFamilyName()==null ? profile.getDisplayName() : profile.getFamilyName());
		
		profile.getEmail();
	}
}
