package de.uniba.minf.registry.controller;

import java.util.Collection;
import java.util.Locale;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.registry.pojo.EntityPojo;
import de.uniba.minf.registry.pojo.converter.EntityConverter;
import de.uniba.minf.registry.repository.EntityRepository;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Tag(name = "Templates", description = "Methods for access to entity templates")
@RestController
@RequestMapping("/api/v1/templates")
public class TemplateController extends BaseRestController<EntityPojo> {

	@Autowired private EntityRepository entityRepo;
	@Autowired private EntityConverter entityConverter;
	
	public TemplateController() {
		super("/api/v1/templates");
	}

	@GetMapping("/")
	public RestItemsResponse getByDefinition(HttpServletRequest request, Locale locale) {
		RestItemsResponse response = new RestItemsResponse();
		
		Collection<EntityPojo> entities = entityConverter.convertPojos(entityRepo.findLatestByCriteria(Criteria.where("template").is(true)));
		
		response.setSize(entities.size());
		response.setLinks(this.getLinks(request.getRequestURL().toString()));
		response.setItems(this.getItems(entities, request.getRequestURL().toString()));
		
		return response;
	}
}
