package de.uniba.minf.registry.controller;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.exception.ApiInsufficientPermissionsException;
import de.uniba.minf.core.rest.exception.ApiItemNotFoundException;
import de.uniba.minf.core.rest.model.RestItemResponse;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.core.rest.model.RestResponse.ApiActions;
import de.uniba.minf.registry.importer.ImportService;
import de.uniba.minf.registry.model.Import;
import de.uniba.minf.registry.model.PersistedUser;
import de.uniba.minf.registry.model.RegistryAccessToken;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.pojo.ImportPojo;
import de.uniba.minf.registry.pojo.converter.ImportConverter;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.ImportRepository;
import de.uniba.minf.registry.repository.UserRepository;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Tag(name = "Import", description = "Access to records on processed import tasks (actual imports " + 
									"of entities are available with the methods of the entities API methods)")
@RestController
@RequestMapping("/api/v1/imports")
public class ImportController extends BaseRestController<ImportPojo> {
	
	public ImportController() {
		super("/api/v1/imports");
	}

	private static final String ITEM_TYPE = "import";
	
	@Autowired private ImportRepository importRepo;
	@Autowired private ImportService importService;
	@Autowired private ImportConverter importConverter;
	
	@GetMapping
	public RestItemsResponse getAllImports(HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
		
		RestItemsResponse resp = new RestItemsResponse();
		
		Collection<ImportPojo> imports = importConverter.convertPojos(importRepo.findAll());
		
		resp.setSize(imports.size());
		resp.setItems(this.getItems(imports, request.getRequestURL().toString()));
		resp.setLinks(this.getLinks(request.getRequestURL().toString()));
		return resp;
	}
	
	@DeleteMapping("/{uniqueId}")
	public RestItemResponse deleteImport(@PathVariable("uniqueId") String uniqueId, HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
		Optional<Import> i = importRepo.findById(uniqueId);
		if (i.isEmpty()) {
			throw new ApiItemNotFoundException(ITEM_TYPE, uniqueId);
		}
		importService.deleteImport(i.get());	
		return this.getItemResponse(importConverter.convertPojo(i.get()), request, ApiActions.DELETED);
	}
	
	
	
}