package de.uniba.minf.registry.controller;

import java.util.Collection;
import java.util.Locale;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.model.RestItemResponse;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.core.rest.model.RestResponse;
import de.uniba.minf.core.rest.model.RestResponse.ApiActions;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.pojo.EntityPojo;
import de.uniba.minf.registry.pojo.converter.EntityConverter;
import de.uniba.minf.registry.repository.EntityRepository;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Tag(name = "Drafts", description = "Access to draft entities accessible to authenticated users")
@RestController
@RequestMapping("/api/v1/drafts")
public class DraftController extends BaseRestController<EntityPojo> {

	@Autowired private EntityRepository entityRepo;
	@Autowired private EntityConverter entityConverter;
	
	public DraftController() {
		super("/api/v1/drafts");
	}

	@GetMapping("/")
	public RestItemsResponse getByDefinition(HttpServletRequest request, Locale locale) {
		RestItemsResponse response = new RestItemsResponse();
		
		Collection<EntityPojo> entities = entityConverter.convertPojos(entityRepo.findLatestByCriteria(Criteria.where("draft").is(true).and("userUniqueId").is(authInfoHelper.getUserId())));
		
		response.setSize(entities.size());
		response.setLinks(this.getLinks(request.getRequestURL().toString()));
		response.setItems(this.getItems(entities, request.getRequestURL().toString()));
		
		return response;
	}
	
	@DeleteMapping
	public RestResponse deleteDrafts(HttpServletResponse resp, Locale locale) {
		Collection<Entity> entities = entityRepo.findLatestByCriteria(Criteria.where("draft").is(true).and("userUniqueId").is(authInfoHelper.getUserId()));
		entityRepo.deleteAll(entities);
		
		RestItemResponse response = new RestItemResponse();
		response.setAction(ApiActions.DELETED);
		return response;
	}
}
