package de.uniba.minf.registry.controller;

import java.util.Locale;
import java.util.Optional;
import jakarta.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.exception.ApiItemNotFoundException;
import de.uniba.minf.core.rest.model.RestItemResponse;
import de.uniba.minf.core.rest.model.RestResponse.ApiActions;
import de.uniba.minf.core.rest.model.RestResponse;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.validation.exception.ValidationConfigurationException;
import de.uniba.minf.registry.service.EntityDefinitionService;
import de.uniba.minf.registry.service.EntityService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;

@Tag(name = "Composite", description = "Specific methods for creating and manipulating composite entities.")
@RestController
@RequestMapping("/api/v1/c")
public class CompositeController extends BaseRestController<Entity>
 {
	public CompositeController() {
		super("/api/v1/c");
	}

	@Autowired private EntityService entityService;
	@Autowired private EntityDefinitionService entityDefinitionService;
		
	@PostMapping("/{entityId}")
	public RestResponse createComposite(@PathVariable(value="entityId") String entityId, HttpServletRequest req, HttpServletResponse resp, Locale locale) throws ValidationConfigurationException, ApiItemNotFoundException {
		Optional<Entity> layerEntity = entityService.findLatestByEntityId(entityId);
		if (layerEntity.isEmpty()) {
			throw new ApiItemNotFoundException("entity", entityId==null ? "NULL" : entityId);
		}
		
		EntityDefinition ed = entityDefinitionService.findCurrentByName(layerEntity.get().getDefinitionName());
		
		Entity compositeEntity = new Entity();
		compositeEntity.setDefinitionName(ed.getName());
		compositeEntity.setDefinitionVersion(ed.getVersion());
		compositeEntity.setDraft(true);
		compositeEntity.addLayer(layerEntity.get().getEntityId());

		// Persist new entity
		return buildItemResponse(ApiActions.CREATED, entityService.save(compositeEntity));
	}
	
		
	private RestItemResponse buildItemResponse(ApiActions action, Entity e) {
		RestItemResponse response = new RestItemResponse();
		response.setAction(action);
		response.setItem(objectMapper.valueToTree(e));
		return response;
	}
}
