package de.uniba.minf.registry.config.db;

import java.time.Instant;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import de.uniba.minf.auth.spring.mvc.AuthInfoHelper;
import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;

@Configuration
public class VocabularyEntryEventListener extends AbstractMongoEventListener<VocabularyEntry> {
	
	@Autowired private AuthInfoHelper authinfoHelper;
	
	@Override
	public void onBeforeConvert(BeforeConvertEvent<VocabularyEntry> event) {
		super.onBeforeConvert(event);
		RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
		String userUniqueId;
		if (attrs != null) {
			userUniqueId = authinfoHelper.getAuth().getUserId();
		} else {
			userUniqueId = "_system";
		}
		
		VocabularyEntry obj = event.getSource();
		obj.setCreationInstant(Instant.now());
		obj.setUserUniqueId(userUniqueId);
		obj.setScore(0);
	}
}
