package de.uniba.minf.registry.config.db;

import java.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import de.uniba.minf.auth.spring.mvc.AuthInfoHelper;
import de.uniba.minf.registry.model.entity.EntityRelation;

@Configuration
public class EntityRelationEventListener extends AbstractMongoEventListener<EntityRelation> {
	
	@Autowired private AuthInfoHelper authinfoHelper;
		
	@Override
	public void onBeforeConvert(BeforeConvertEvent<EntityRelation> event) {
		super.onBeforeConvert(event);
		
		RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
		String userUniqueId;
		if (attrs != null) {
			userUniqueId = authinfoHelper.getAuth().getUserId();
		} else {
			userUniqueId = "_system";
		}
		
		EntityRelation obj = event.getSource();
		obj.setCreationInstant(Instant.now());
		obj.setUserUniqueId(userUniqueId);
	}
}