package de.uniba.minf.registry.config;

import org.pac4j.core.config.Config;
import org.pac4j.core.context.HttpConstants.HTTP_METHOD;
import org.pac4j.core.matching.matcher.HttpMethodMatcher;
import org.pac4j.springframework.annotation.AnnotationConfig;
import org.pac4j.springframework.component.ComponentConfig;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import de.uniba.minf.auth.spring.config.SecurityConfig;

/**
 * Web security configuration addressing protected areas and authorization patterns for this sample application
 * 
 * @author Tobias Gradl
 */
@Configuration
@Import({ComponentConfig.class, AnnotationConfig.class})
public class WebSecurityConfig implements WebMvcConfigurer {

	@Autowired private Config config;
    @Autowired private SecurityConfig securityConfig;
    
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
    	if (!securityConfig.isEnabled()) {
    		return;
    	}
    	
    	registry.addInterceptor(buildInterceptor(securityConfig.getIndirectStartClientName())).addPathPatterns("/protected/**", "/imports/**");
    	registry.addInterceptor(buildInterceptor("saml")).addPathPatterns("/protected_saml/*");
    	    	  	
    	// Initiate login based on local client (for form), but allow any profile with an account with ROLE_ADMINISTRATOR 
        //SecurityInterceptor interceptor = SecurityInterceptor.build(config, securityConfig.getIndirectStartClientName(), new RequireAnyRoleAuthorizer("ROLE_ADMINISTRATOR"));
        // registry.addInterceptor(interceptor).addPathPatterns("/localadmin/*");


        // Protection with all available clients, but no redirection to login
        //registry.addInterceptor(buildInterceptor(securityConfig.getDirectClientNames())).addPathPatterns("/api/**");
        
        // TODO: This is actually correct....
        // Protection only of selected HTTP methods
        SecurityInterceptor modifyingRestCallInterceptor = SecurityInterceptor.build(config, securityConfig.getDirectClientNames(), new HttpMethodMatcher(HTTP_METHOD.DELETE, HTTP_METHOD.POST, HTTP_METHOD.PUT));
        registry.addInterceptor(modifyingRestCallInterceptor).addPathPatterns("/api/**");
    }

    private SecurityInterceptor buildInterceptor(final String client) {
        return SecurityInterceptor.build(config, client);
    }
	


}
