package de.uniba.minf.registry.config;

import org.apache.tika.Tika;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.serialization.EntityDefinitionDeserializer;
import de.uniba.minf.registry.model.serialization.EntityDefinitionSerializer;
import de.uniba.minf.registry.model.serialization.EntityDeserializer;
import de.uniba.minf.registry.model.serialization.VocabularyDefinitionDeserializer;
import de.uniba.minf.registry.model.serialization.VocabularyDefinitionSerializer;
import de.uniba.minf.registry.model.serialization.VocabularyEntryDeserializer;
import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;

@Configuration
public class SerializationConfig {
	
	@Bean("jsonMapper")
	@Primary
	ObjectMapper jsonMapper(SimpleModule serializationModule) {
		ObjectMapper jsonMapper = new ObjectMapper();		
		jsonMapper.registerModule(serializationModule);
		jsonMapper.registerModule(javaTimeModule());
		jsonMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
		jsonMapper.setSerializationInclusion(Include.NON_NULL);
		return jsonMapper;
	}
	
	@Bean("yamlMapper")
	ObjectMapper yamlMapper(SimpleModule serializationModule) {
		ObjectMapper yamlMapper = new ObjectMapper(new YAMLFactory());
		yamlMapper.registerModule(serializationModule);
		yamlMapper.registerModule(javaTimeModule());
		yamlMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
		yamlMapper.setSerializationInclusion(Include.NON_NULL);
		return yamlMapper;
	}
	
	@Bean
	@Primary
	SimpleModule serializationModule(EntityDeserializer entityDeserializer, VocabularyEntryDeserializer vocabularyEntryDeserializer) {
		SimpleModule module = new SimpleModule();
		module.addDeserializer(Entity.class, entityDeserializer);
		module.addDeserializer(VocabularyEntry.class, vocabularyEntryDeserializer);
		
		module.addDeserializer(EntityDefinition.class, new EntityDefinitionDeserializer());
		module.addDeserializer(VocabularyDefinition.class, new VocabularyDefinitionDeserializer());
		module.addSerializer(EntityDefinition.class, new EntityDefinitionSerializer());
		module.addSerializer(VocabularyDefinition.class, new VocabularyDefinitionSerializer());
		return module;
	}
	
	@Bean
	EntityDeserializer entityDeserializer() {
		return new EntityDeserializer();
	}
	
	@Bean
	VocabularyEntryDeserializer vocabularyEntryDeserializer() {
		return new VocabularyEntryDeserializer();
	}
	
	@Bean
	JavaTimeModule javaTimeModule() {
		return new JavaTimeModule();
	}
	
	@Bean
	Tika tika() {
		return new Tika();
	}
}
