package de.uniba.minf.registry.config;

import java.util.Collection;
import java.util.Collections;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.config.AbstractMongoClientConfiguration;
import org.springframework.data.mongodb.core.mapping.event.ValidatingMongoEventListener;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import lombok.Getter;
import lombok.Setter;

@Configuration
@ConfigurationProperties(prefix="mongodb")
@EnableMongoRepositories(basePackages = "de.uniba.minf.registry.repository")
public class BackendConfig extends AbstractMongoClientConfiguration {
	@Getter @Setter private String host = "localhost";
	@Getter @Setter private String port = "27017";
	@Getter @Setter private String databaseName = "registry";
	@Getter @Setter private String username;
	@Getter @Setter private String password;
	@Getter @Setter private String authCollection;
	
	
    @Bean
    ValidatingMongoEventListener validatingMongoEventListener() {
        return new ValidatingMongoEventListener(validator());
    }

    @Bean
    LocalValidatorFactoryBean validator() {
        return new LocalValidatorFactoryBean();
    }
	
	@Override
	protected void configureClientSettings(MongoClientSettings.Builder builder) {
		String uri;
        if (username!=null && password!=null) {
        	if (authCollection!=null) {
        		uri = String.format("mongodb://%s:%s@%s:%s/%s?authSource=%s", username, password, host, port, databaseName, authCollection);
        	} else {
        		uri = String.format("mongodb://%s:%s@%s:%s/%s", username, password, host, port, databaseName);
        	}
        } else {
        	uri = String.format("mongodb://%s:%s/%s", host, port, databaseName);
        }
	    // customization hook
	    builder.applyConnectionString(new ConnectionString(uri));
	}
    
    @Override
    protected boolean autoIndexCreation() {
    	return true;
    }
 
    @Override
    public Collection<String> getMappingBasePackages() {
        return Collections.singleton("de.uniba.minf.registry.model");
    }
}
