package de.uniba.minf.registry.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import de.uniba.minf.auth.spring.config.SecurityConfig;

/**
 * Main security configuration extends {@link ApplicationSecurityConfig}. The auth namespace of the configuration properties 
 *  is utilized for the configuration of the extended {@link ApplicationSecurityConfig}.
 *  
 * Import of the {@link AuthInfoConfigurer} class ultimately ensures configuration of the {@link AuthInfoHandlerInterceptor} 
 * 
 * @author Tobias Gradl
 */
@Configuration
@ConfigurationProperties(prefix = "auth")
public class ApplicationSecurityConfig extends SecurityConfig {
	
}
