let tokenTable;

$(document).ready(function() {
	const userId = $("#token-table").data("entity");
	tokenTable = new TokenTable({
		url: __util.composeUrl("api/v1/tokens/" + userId),
		containerSelector: "#token-table-container",
		selector: "#token-table",
		userId: userId
	});
});


class TokenTable extends BaseTable {
    constructor(options) {
        super($.extend(true, {
	            containerSelector: "#entity-table-container",
	            selector: "#entity-table",
	            initMaxColumns: -1,
	            buttons: [],
	        }, options),
	        	[
					"view.dialog.false",
		            "view.dialog.true",
		            "view.dialog.na",
		
		            "view.dialog.access_token.enter_token_name",
		            "view.dialog.access_token.note_new_token",
		            "view.dialog.access_token.token_creation_failed",
		            "view.dialog.access_token.no_name_set",
		            "view.dialog.access_token.token_deletion_failed",
		            "view.dialog.access_token.token_deleted",
		            "view.dialog.access_token.delete_token",
		            "view.model.access_token.action.create_new"
            	]
	        );	    
        const _this = this;
        this.initTranslations(function() {
			_this.addButtons();
			_this.applyBaseSettings();
            _this.createTable();
        });

    }
    
    addButtons() {
		const _this = this;
		if (__auth.isAuthenticated()) {
            this.options.buttons.push({
                text: this.renderButtonTitle('add', "view.model.access_token.action.create_new"),
                className: 'btn btn-primary',
                action: function() {
                    _this.triggerCreateToken();
                }
            });
        }
	}
    
    assignTableEvents() {
		super.assignTableEvents();
		
		const _this = this;
        $('#token-table tbody').on('click', 'button.btn-delete', function() {
            const data = _this.table.row($(this).parents('tr')).data();
            bootbox.confirm({
                message: __translator.translate('view.dialog.access_token.delete_token', data.name),
                locale: "current",
                callback: function(result) {
                    if (result) {
                        _this.deleteToken(data.id);
                    }
                }
            });
        });
	}
    
    triggerCreateToken() {
        const _this = this;
        bootbox.prompt({
            title: __translator.translate("view.dialog.access_token.enter_token_name"),
            locale: 'current',
            callback: function(result) {
                if (result != null && result.length > 0) {
                    $.ajax({
                        type: "POST",
                        url: __util.composeUrl("api/v1/tokens/" + _this.options.userId),
                        contentType: "application/json; charset=UTF-8",
                        data: JSON.stringify({ "name": result }),
                        success: function(data) {
                            if ((data.action == "UPDATED" || data.action == "CREATED")) {
                                __util.showAlert("success", __translator.translate("view.dialog.access_token.note_new_token", data.item.uniqueId));
                            }
                            _this.refresh();
                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            if (jqXHR?.responseJSON) {
                                __util.showAlert("danger", __translator.translate("view.dialog.access_token.token_creation_failed", textStatus));
                            }
                        },
                        dataType: "json"
                    });
                } else if (result != null) {
                    __util.showAlert("warning", __translator.translate("view.dialog.access_token.no_name_set"));
                }
            }
        });
    }
    
    
    deleteToken(id) {
        const _this = this;
        $.ajax({
            type: "DELETE",
            url: __util.composeUrl("api/v1/tokens/" + _this.options.userId + "/" + id),
            success: function() {
                __util.showAlert("info", __translator.translate("view.dialog.access_token.token_deleted"));
                _this.refresh();
            },
            error: function(jqXHR, textStatus, errorThrown) {
                if (jqXHR?.responseJSON) {
                    __util.showAlert("danger", __translator.translate("view.dialog.access_token.token_deletion_failed"));
                }
            },
            dataType: "json"
        });
    }
    
    renderSpecialColumn(name, row, type, val, meta) {
        if (type !== "display") {
            return "";
        } else {
            return '<div class="btn-group">' +
                '<button class="btn btn-danger btn-sm btn-delete"><i class="bi bi-trash"></i></button>' +
                '</div>';
        }
    }
}

