let usergroupTable;

$(document).ready(function() {
	usergroupTable = new UsergroupTable({
		url: __util.composeUrl("api/v1/uga"),
		containerSelector: "#group-table-container",
	    selector: "#group-table"
	});
});


class UsergroupTable extends BaseTable {
    constructor(options) {
		super($.extend(true, {
	            containerSelector: "#entity-table-container",
	            selector: "#entity-table",
	            initMaxColumns: -1,
	            
	            buttons: [],
	            rowGroup: {
	                dataSrc: 'uniqueId',
	                startRender: function(rows, group) {
	                    return _this.renderGroupRow(rows.data().pluck("name")[0], rows.data().pluck("currentUserCanEdit")[0], group);
	                }
	            }
	        }, options),
	        	[
					"view.dialog.false",
		            "view.dialog.true",
		            "view.dialog.na",
		
		            "model.user.name",
		
		            "view.dialog.user_group.enter_group_name",
		            "view.dialog.user_group.note_new_group",
		            "view.dialog.user_group.group_creation_failed",
		            "view.dialog.user_group.no_name_set",
		            "view.dialog.user_group.delete_group",
		            "view.dialog.user_group.group_deleted",
		            "view.dialog.user_group.group_deletion_failed",
		
		            "view.dialog.user_group.add_user",
		            "view.dialog.user_group.no_username_set",
		            "view.dialog.user_group.user_added",
		            "view.dialog.user_group.add_user_failed",
		
		            "view.dialog.user_group.remove_user_from_group",
		            "view.dialog.user_group.removed_user_from_group",
		            "view.dialog.user_group.remove_user_from_group_failed",
		
		            "model.user_group.members.owner",
		            "model.user_group.members.write_access",
		            "model.user_group.members.expired",
		
		            "view.model.user_groups.expiration_with_format_hint",
		            "view.model.user_groups.action.create_new"
            	]
	        );
	        
        const _this = this;
        this.initTranslations(function() {
			_this.addButtons();
			_this.applyBaseSettings();
            _this.createTable();
        });
    }
    				
	addButtons() {
		const _this = this;
		if (__auth.isAuthenticated()) {

            this.options.buttons.push({
                text: this.renderButtonTitle('add', "view.model.user_groups.action.create_new"),
                className: 'btn btn-primary',
                action: function() {
                   _this.triggerCreateOrEditUsergroup()
                }
            });
        }
	}
	
	assignTableEvents() {
		super.assignTableEvents();

		const _this = this;
        $(this.options.selector).find('tbody').on('click', 'button.btn-remove-user', function() {
            const data = _this.table.row($(this).parents('tr')).data();
            _this.removeUserFromGroup(data);
        });
        $(this.options.selector).find('tbody').on('click', 'button.btn-edit-user', function() {
            const data = _this.table.row($(this).parents('tr')).data();
            _this.triggerEditUser(data);
        });
	}
	
	
    renderGroupRow(name, edit, uniqueId) {
        let tr = $("<tr>");
        if (edit) {
            $(tr).append($("<th>").text(name).prop("colspan", 3));
            $(tr).append('<th>' +
			                '<div class="btn-group">' +
			                	'<button class="btn btn-outline-danger btn-sm" onclick="usergroupTable.triggerDeleteGroup(\'' + uniqueId + '\');"><i class="bi bi-trash"></i></button>' +
			                	'<button class="btn btn-outline-primary btn-sm" onclick="usergroupTable.triggerCreateOrEditUsergroup(\'' + uniqueId + '\');"><i class="bi bi-pencil-square"></i></button>' +
			                	'<button class="btn btn-outline-primary btn-sm" onclick="usergroupTable.triggerAddUserToGroup(\'' + uniqueId + '\');"><i class="bi bi-person-add"></i></button>' +
			                '</div>' +
		                '</th>');
        } else {
            $(tr).append($("<th>").text(name).prop("colspan", 4));
        }
        return tr;
    }
    
    renderSpecialColumn(name, row, type, val, meta) {
        if (name == "group") {
            return this.renderGroupColumn(row, type, val, meta);
        } else if (name == "member") {
            return this.renderMemberColumn(row, type, val, meta);
        } else {
            return this.renderActionColumn(row, type, val, meta);
        }
    }
    
    renderActionColumn(row, type, val, meta) {
        if (type !== "display") {
            return "";
        } else if (!row.owner && row.currentUserCanEdit) {
            return '<div class="btn-group">' +
		                '<button class="btn btn-outline-danger btn-sm btn-remove-user"><i class="bi bi-x"></i></button>' +
		                '<button class="btn btn-outline-primary btn-sm btn-edit-user"><i class="bi bi-pencil-square"></i></button>' +
	                '</div>';
        } else {
            return "";
        }
    }
    
    renderMemberColumn(row, type, val, meta) {
        if (type !== "display") {
            let member = row.username;
            if (row.owner) {
                member += ' ' + __translator.translate("model.user_group.members.owner");
            } else if (row.writeAccess) {
                member += ' ' + __translator.translate("model.user_group.members.write_access");
            }
            if (row.expired) {
                member += ' ' + __translator.translate("model.user_group.members.expired");
            }
            return member;
        } else {
            let member = "";

            if (row.pending) {
                member += '<i class="bi bi-person"></i> ';
            } else {
                member += '<i class="bi bi-person-fill"></i> ';
            }
            member += row.username;

            // Status options
            if (row.owner) {
                member += ' <span class="badge bg-primary">' + __translator.translate("model.user_group.members.owner") + '</span> ';
            } else if (row.writeAccess) {
                member += ' <span class="badge bg-primary">' + __translator.translate("model.user_group.members.write_access") + '</span> ';
            }
            if (row.expired) {
                member += ' <span class="badge bg-danger">' + __translator.translate("model.user_group.members.expired") + '</span> ';
            }
            return member;
        }
    }
    renderGroupColumn(row, type, val, meta) {
        if (type === "display") {
            return row.name;
        } else {
            return row.uniqueId;
        }
    }
    
    triggerCreateOrEditUsergroup(uniqueId) {
        const _this = this;

        bootbox.prompt({
            title: __translator.translate("view.dialog.user_group.enter_group_name"),
            locale: 'current',
            callback: function(result) {
                if (result != null && result.length > 0) {
                    $.ajax({
                        type: "POST",
                        url: __util.composeUrl("api/v1/uga" + (uniqueId == undefined ? '' : ('/' + uniqueId))),
                        contentType: "application/json; charset=UTF-8",
                        data: JSON.stringify({ "name": result }),
                        success: function(data) {
                            if ((data.action == "UPDATED" || data.action == "CREATED")) {
                                __util.showAlert("success", __translator.translate("view.dialog.user_group.note_new_group"));
                            }
                            _this.refresh();
                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            if (jqXHR !== undefined && jqXHR.responseJSON !== undefined) {
                                __util.showAlert("danger", __translator.translate("view.dialog.user_group.group_creation_failed", textStatus));
                            }
                        },
                        dataType: "json"
                    });
                } else if (result != null) {
                    __util.showAlert("warning", __translator.translate("view.dialog.user_group.no_name_set"));
                }
            }
        });
    }
    
    triggerDeleteGroup(uniqueId) {
        const _this = this;
        bootbox.confirm({
            message: __translator.translate('view.dialog.user_group.delete_group'),
            locale: "current",
            callback: function(result) {
                if (result) {
                    $.ajax({
                        type: "DELETE",
                        url: __util.composeUrl("api/v1/uga/" + uniqueId),
                        success: function() {
                            __util.showAlert("info", __translator.translate("view.dialog.user_group.group_deleted"));
                            _this.refresh();
                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            if (jqXHR !== undefined && jqXHR.responseJSON !== undefined) {
                                __util.showAlert("danger", __translator.translate("view.dialog.user_group.group_deletion_failed"));
                            }
                        },
                        dataType: "json"
                    });
                }
            }
        });
    }
    
    removeUserFromGroup(data) {
        const _this = this;
        bootbox.confirm({
            message: __translator.translate('view.dialog.user_group.remove_user_from_group'),
            locale: "current",
            callback: function(result) {
                if (result) {
                    $.ajax({
                        type: "DELETE",
                        url: __util.composeUrl("api/v1/uga/" + data.uniqueId + "/user/" + data.assignmentUniqueId),
                        success: function() {
                            __util.showAlert("info", __translator.translate("view.dialog.user_group.removed_user_from_group"));
                            _this.refresh();
                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            if (jqXHR !== undefined && jqXHR.responseJSON !== undefined) {
                                __util.showAlert("danger", __translator.translate("view.dialog.user_group.remove_user_from_group_failed"));
                            }
                        },
                        dataType: "json"
                    });
                }
            }
        });
    }
    
    triggerEditUser(data) {
        const form = '<form id="group-assign-form" class="bootbox-form">' +
            '<div class="mb-3">' +
            '<label for="group-assign-username" class="form-label">' + __translator.translate("model.user.name") + '</label>' +
            '<input type="text" class="bootbox-input bootbox-input-text form-control" id="group-assign-username" autocomplete="off" value="' + (data?.username ? data?.username : '') + '">' +
            '</div>' +
            '<div class="mb-3">' +
            '<label for="group-assign-expiration" class="form-label">' + __translator.translate("view.model.user_groups.expiration_with_format_hint") + '</label>' +
            '<input type="text" class="bootbox-input bootbox-input-text form-control" id="group-assign-expiration" autocomplete="off" value="' + (data?.expirationString ? data?.expirationString : '') + '">' +
            '</div>' +
            '<div class="mb-3">' +
            '<div class="form-check">' +
            '<input class="form-check-input" type="checkbox" ' + (data?.writeAccess ? 'checked' : '') + ' id="group-assign-writeAccess">' +
            '<label class="form-check-label" for="group-assign-writeAccess">' +
            __translator.translate("model.user_group.members.write_access") +
            '</label>' +
            '</div>' +
            '</div>' +
            '</form>';

        const _this = this;
        bootbox.confirm({
            title: __translator.translate("view.dialog.user_group.add_user"),
            message: form,
            locale: 'current',
            callback: function(result) {
                if (result) {
                    const username = $("#group-assign-form #group-assign-username").val();
                    const expiration = $("#group-assign-form #group-assign-expiration").val();
                    const writeAccess = $("#group-assign-form #group-assign-writeAccess").is(':checked');

                    if (username.length > 0) {
                        $.ajax({
                            type: "POST",
                            url: __util.composeUrl("api/v1/uga/" + data.uniqueId + "/user"),
                            contentType: "application/json; charset=UTF-8",
                            data: JSON.stringify({
                                "username": username,
                                "expirationString": expiration,
                                "writeAccess": writeAccess,
                                "assignmentUniqueId": data?.assignmentUniqueId == undefined ? null : data.assignmentUniqueId
                            }),
                            success: function(data) {
                                if ((data.action == "UPDATED" || data.action == "CREATED")) {
                                    __util.showAlert("success", __translator.translate("view.dialog.user_group.user_added"));
                                }
                                _this.refresh();
                            },
                            error: function(jqXHR, textStatus) {
                                if (jqXHR !== undefined && jqXHR.responseJSON !== undefined) {
                                    __util.showAlert("danger", __translator.translate("view.dialog.user_group.add_user_failed", textStatus));
                                }
                            },
                            dataType: "json"
                        });
                    } else if (result != null) {
                        __util.showAlert("warning", __translator.translate("view.dialog.user_group.no_username_set"));
                    }
                }
            }
        });
    }
    
    triggerAddUserToGroup(uniqueId) {
        this.triggerEditUser({ uniqueId: uniqueId });
    }    
}