let importForm;
$(document).ready(function() {
	importForm = new ImportForm();
});

const ImportForm = function() {
	const _this = this;
	
	__translator.addTranslations([
		"view.import.messages.import_data_required",
		"view.import.messages.target_entity_required",
		"view.import.messages.validation_result_valid",
		"view.import.messages.no_change_no_save",
		"view.import.messages.empty_record",
		"view.import.messages.validation_result.validated",
		"view.import.messages.validation_result.successful",
		"view.import.messages.validation_result.unknown_properties",
		"view.import.messages.validation_result.validation_errors",
		"view.import.messages.import_result.imported",
		"view.import.messages.import_result.successful",
		"view.import.messages.import_result.unknown_properties",
		"view.import.messages.import_result.validation_errors",
		"view.import.messages.import_result.vocabulary.matched_and_set_candidate",
		"view.import.messages.import_result.vocabulary.too_many_candidates",
		"view.import.messages.import_result.vocabulary.no_candidates_to_choose_from",
		"view.dialog.import_value_mappings.changed_reload"
	]);
	__translator.getTranslations();
	
	$("#import-form").on("submit", function(event) { _this.submit(true); event.preventDefault(); });
	
	this.mappingTable = new ImportMappingTable({});
};


ImportForm.prototype.submit = function(doImport) {
	let entity = $("#target-entity").val();
	let template = $("#import-template").val();
	let format = $('input[name="import-format"]:checked').val();
	let importType = $('input[name="import-type"]:checked').val();
	let importData = $("#import-data").val();
	let importUrl = $("#import-data-url").val();
	
	if (!entity) {
		__util.showAlert("warning", __translator.translate("view.import.messages.target_entity_required"));
		return;	
	}
	if (!importData?.trim() && !importUrl.trim()) {
		__util.showAlert("warning", __translator.translate("view.import.messages.import_data_required"));
		return;	
	}
	
	$(".hide-while-loading").addClass("disabled");
	$(".show-while-loading").show();
	
	const _this = this;
	$.ajax({
		type: "POST",
		url: __util.composeUrl("api/v1/e/" + entity + (doImport ? "/import" : "/validate")),
		data: JSON.stringify({ 
			data: importData ? importData : null, 
			mappings: this.mappingTable.table.data().toArray(),
			importType: importType ? importType : null,
			template: template,
			format: format,
			importUrl: importUrl
		}),
		contentType: "application/json; charset=UTF-8",
		success: function(data) {
			/*if (data.action=="CREATED") {
				window.location.replace(__util.composeUrl("imports/" + data.item.uniqueId + "/entities/"));
			} else {
				_this.processResponse(data, doImport);
				$(".hide-while-loading").removeClass("disabled");
				$(".show-while-loading").hide();
			}*/
			
			let alertMessage = '<h4 class="alert-heading">' + (doImport ? "Import" : "Validation") + ' started</h4>';
			let alertType = "success";
			
			if (data.action) {
				alertMessage += "refresh url: <a href='" + data.action + "'>" + data.action + "</a>";
			}
			
			__util.showAlert(alertType, alertMessage);
			
			$(".hide-while-loading").removeClass("disabled");
			$(".show-while-loading").hide();
			
			setTimeout(function() { _this.refreshImportResponse(data.action, doImport); }, 3000);
		},
		error: function(jqXHR) {
			if (jqXHR?.responseJSON!==undefined) {
				_this.processResponse(jqXHR.responseJSON);
				__util.showErrorResponse(jqXHR.responseJSON, "danger");
			}
			$(".hide-while-loading").removeClass("disabled");
			$(".show-while-loading").hide();
		},
		dataType: "json"
	});
};

ImportForm.prototype.refreshImportResponse = function(url, doImport) {
    const _this = this;
    
    $.ajax({
		type: "GET",
		url: url,
		success: function(data) {
			
			if (data.serverStatus=="BUSY") {
				setTimeout(function() { _this.refreshImportResponse(data.action, doImport); }, 3000);
			} else {
				_this.processResponse(data, doImport);
			}
			
		},
		error: function(jqXHR) {
			
		},
		dataType: "json"
    });
}

ImportForm.prototype.processResponse = function(data, doImport) {
	this.processOverallResult(data, doImport);
	this.showImportResult();
}

ImportForm.prototype.processOverallResult = function(data, doImport) {
	let result = {
		importPerformed: data.action=="UPDATED" || data.action=="CREATED",
		validationPerformed: data.action=="UNCHANGED" && !doImport,
		noResults: data.action=="UNCHANGED" && doImport,
		hasItems: data.items?.length>0 || false,
		items: data.items || [],
		unknownProperties: data._serverData?.unknownProperties || [],
		validationErrors: data._serverData?.validationErrors || [],
		resolvedVocabularyEntries: data._serverData?.resolvedVocabularyEntries || [],
	};
	
	result.hasValidationErrors = result.validationErrors.some(p => Array.isArray(p) && p.length>0);
	result.hasUnknownProperties = result.unknownProperties.some(p => Array.isArray(p) && p.length>0);
	result.hasResolvedVocabularyEntries = result.resolvedVocabularyEntries.some(p => Array.isArray(p) && p.length>0);
		
	let alertMessage;
	let alertType = "success";
	
	// Some or all data was saved
	if (result.importPerformed) {
		alertMessage = '<h4 class="alert-heading">' + __translator.translate("view.import.messages.import_result.imported") + '</h4>';
		
		// Some records have validation errors and were saved as drafts
		// Some records have unknown properties that were ignored
		if (result.hasValidationErrors && result.hasUnknownProperties) {
			alertMessage += "<ul>" + 
								"<li>" + __translator.translate("view.import.messages.import_result.validation_errors") + "</li>" +
								"<li>" + __translator.translate("view.import.messages.import_result.unknown_properties") + "</li>" +
							"</ul>"
			alertType = "warning";
		}
		// Some records have validation errors and were saved as drafts
		else if (result.hasValidationErrors) {
			alertMessage += __translator.translate("view.import.messages.import_result.validation_errors");
			alertType = "warning";
		}
		// No validation errors, but some records have unknown properties that were ignored
		else if (result.hasUnknownProperties) {
			alertMessage += __translator.translate("view.import.messages.import_result.unknown_properties")
			alertType = "info";
		}
		// So warnings or messages at all
		else {
			alertMessage = __translator.translate("view.import.messages.import_result.successful")
		}
	}
	// Validation performed
	else if (result.validationPerformed) {
		alertMessage = '<h4 class="alert-heading">' + __translator.translate("view.import.messages.validation_result.validated") + '</h4>';
		
		// Some records have validation errors
		// Some records have unknown properties
		if (result.hasValidationErrors && result.hasUnknownProperties) {
			alertMessage += "<ul>" + 
								"<li>" + __translator.translate("view.import.messages.validation_result.validation_errors") + "</li>" +
								"<li>" + __translator.translate("view.import.messages.validation_result.unknown_properties") + "</li>" +
							"</ul>"
			alertType = "warning";
		}
		// Some records have validation errors
		else if (result.hasValidationErrors) {
			alertMessage += __translator.translate("view.import.messages.validation_result.validation_errors");
			alertType = "warning";
		}
		// No validation errors, but some records have unknown properties
		else if (result.hasUnknownProperties) {
			alertMessage += __translator.translate("view.import.messages.validation_result.unknown_properties")
			alertType = "info";
		}
		// So warnings or messages at all
		else {
			alertMessage = __translator.translate("view.import.messages.validation_result.successful")
		}
	}
	// Import attempted, but no changes => no items detected
	else if (result.noResults) {
		alertMessage = __translator.translate("view.import.messages.no_change_no_save");
		alertType = "warning";
	}
	this.result = result;
	__util.showAlert(alertType, alertMessage);
}

ImportForm.prototype.showImportResult = function() {
	if (this.result.items==undefined || this.result.items.length==0) {
		$("#import-result").hide();
	} else {
		this.showItem(0);
		$("#import-result").show();
	} 
	$(window).scrollTop(0);
};

ImportForm.prototype.showItem = function(index) {
	$("#import-result legend").removeClass("bg-success").removeClass("bg-warning").removeClass("bg-danger").removeClass("bg-info");
	$("#import-result").removeClass("border-success").removeClass("border-warning").removeClass("border-danger").removeClass("border-info");
	$("#import-result-icon").html('');
	
	$("#import-success").html('');
	$("#import-messages-container ul").html('');
	$("#import-validation-violations").html('');
	$("#imported-resources").html('');
	
	$("#import-messages-container .accordion-item").hide();
	$("#import-messages-container .accordion-body").text('');	
	
	let state = "success";		
	if (this.result?.unknownProperties[index].length+this.result?.validationErrors[index].length+this.result?.resolvedVocabularyEntries[index].length==0) {
		$("#import-success").show();
		$("#import-result-icon").html('<i class="bi bi-check"></i>');
	} else {
		$("#import-success").hide();
		if (this.result?.validationErrors[index].length>0) {
			$("#import-result-icon").html('<i class="bi bi-exclamation-triangle"></i>');
			state = "warning";
		} else {
			$("#import-result-icon").html('<i class="bi bi-question-circle"></i>');
			state = "info";	
		}
		this.showValidationViolations(this.result?.validationErrors[index]);
		this.showUnknownFields(this.result?.unknownProperties[index]);
		this.showResolvedVocabularyEntries(this.result?.resolvedVocabularyEntries[index]);
	}
	
	// Show record properties
	if (this.result.items[index].properties==undefined || this.result.items[index].properties.length==0) {
		if (state=="success") {
			state = "info";
		}
		$("#imported-resources").html(__translator.translate("view.import.messages.empty_record"));
	} else {
		$("#imported-resources").html(this.showItemProperties(this.result.items[index].properties, null, this.result?.validationErrors[index], this.result?.resolvedVocabularyEntries[index]));
	}
	
	$("#import-result legend").addClass("bg-" + state);
	$("#import-result").addClass("border-" + state);
	
	$('[data-bs-toggle="tooltip"]').tooltip();
		
	this.handleItemNavigation(index);
};

ImportForm.prototype.showItemProperties = function(properties, path, validationErrors, resolvedVocabularyEntries) {
	const list = $("<ul class='import-result-list'>");
	
	if (properties) {
		for (let prop of properties) {
			let propPath = (path==null ? prop.label : (path + "." + prop.label));
	
			// Propertylists below hierarchical property
			if (prop.properties) {
				for (let j=0; j<prop.properties.length; j++) {
					let li = $("<li>");
					let propListPath = propPath + "[" + j + "]";
					$(li).append("<span class='property-label'>" + prop.label + "</span>")
						.append(": ");
					
					$(li).append(this.showItemProperties(prop.properties[j].properties, propListPath, validationErrors, resolvedVocabularyEntries));
					this.handleItemPropertyStatus(propListPath, li, validationErrors, resolvedVocabularyEntries);
					$(list).append(li);
				}
			} else {
				let li = $("<li>");
				$(li).append("<span class='property-label'>" + prop.label + "</span>")
					.append(": ");
				if (prop.value?.value) {
					$(li).append("<span class='property-value'>" + __util.asLinkIfLink(prop.value.value, ' <i class="bi bi-box-arrow-up-right"></i>', "_BLANK") + "</span>");
					li.data("value", prop.value.value);
				}
				if (prop.value?.values) {
					let values = $("<ul class='property-values'>");
					for (let j=0; j<prop.value.values.length; j++) {
						let propValuePath = propPath + "[" + j + "]";
						let valueLi = $("<li>");
						valueLi.data("value", prop.value.values[j].value);
						valueLi.append("<span class='property-value'>" + __util.asLinkIfLink(prop.value.values[j].value, ' <i class="bi bi-box-arrow-up-right"></i>', "_BLANK") + "</span>");
						this.handleItemPropertyStatus(propValuePath, valueLi, validationErrors, resolvedVocabularyEntries);
						$(values).append(valueLi);
					}
					$(li).append(values);
				}
				this.handleItemPropertyStatus(propPath, li, validationErrors, resolvedVocabularyEntries);
				$(list).append(li);
			}
		}
	}
	return list;
};

ImportForm.prototype.triggerManualResolve = function(control) {
	const li = $(control).closest("li");
	
	const vocabulary = $(li).data("resolve-vocabulary");
	const value = $(li).data("resolve-query");
	const allocation = $(li).data("resolve-key");
	
	this.mappingTable.triggerAddRow(value, allocation, function(v, a) {
		const li = $("#import-form li").filter( function(){ return $(this).data('resolve-query')==v });
		
		if (li.find(".bi bi-arrow-clockwise").length==0) {
			const i = $('<i class="bi bi-arrow-clockwise" ' + 
									'data-bs-toggle="tooltip" data-bs-placement="top" ' + 
									'data-bs-title="' + __translator.translate("view.dialog.import_value_mappings.changed_reload") + '"></i> ');
			li.prepend(i);
			$(i).tooltip();
		}
		li.find(".property-resolved-value").html(__util.asLinkIfLink(a, ' <i class="bi bi-box-arrow-up-right"></i>', "_BLANK"));
	});
}

ImportForm.prototype.handleItemNavigation = function(index) {
	$("#curr-item").text((index+1) + " / " + this.result.items.length);
	
	if (index==0) {
		$("#btn-prev-item").data("nav-index", index).html('<i class="bi bi-caret-left"></i>');
	} else {
		$("#btn-prev-item").data("nav-index", index-1).html('<i class="bi bi-caret-left-fill"></i>');
	}
	if (index<this.result.items.length-1) {
		$("#btn-next-item").data("nav-index", index+1).html('<i class="bi bi-caret-right-fill"></i>');
	} else {
		$("#btn-next-item").data("nav-index", this.result.items.length-1).html('<i class="bi bi-caret-right"></i>');
	}
};

ImportForm.prototype.showValidationViolations = function(violations) {
	if (violations.length>0) {
		$("#import-validation-errors").parent(".accordion-item")
			.show()
			.find(".message-count").text(violations.length);
		
		for (const violation of violations) {
			$("#import-validation-errors ul").append("<li><i class='bi bi-exclamation-triangle text-danger'></i> " + violation.message + " (" + violation.name + ")</li>");
		}
	}
};

ImportForm.prototype.showUnknownFields = function(fields) {
	if (fields.length>0) {
		$("#import-unknown-properties").parent(".accordion-item")
			.show()
			.find(".message-count").text(fields.length);
		var unknown = [];
		for (const field of fields) {
			if (!unknown.includes(field.path)) {
				unknown.push(field.path);
			}
		}
		for (const u of unknown) {
			$("#import-unknown-properties ul").append("<li><i class='bi bi-question-circle text-info'></i> " + u);
		}
	}
};

ImportForm.prototype.handleItemPropertyStatus = function(path, listItem, validationErrors, resolvedVocabularyEntries) {
	let check = true; 

	for (const res of resolvedVocabularyEntries) {
		if (res.path==path && listItem.data("value")==res.query) {
			this.showResolvedVocabularyEntry(res, listItem);
			check = false;
		}
	}
	
	for (const err of validationErrors) {
		if (err.name==path && listItem.data("value")==err.value) {
			check = false;
			$(listItem).prepend('<i class="bi bi-exclamation-triangle text-danger" ' + 
									'data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="custom-tooltip-danger" ' + 
									'data-bs-title="' + err.message + '"></i> ');
		}
	}
	
	if (check) {
		$(listItem).prepend('<i class="bi bi-check"></i> ');
	}
}

ImportForm.prototype.showResolvedVocabularyEntries = function(resolvedEntries) {
	if (resolvedEntries.length>0) {		
		let warning = false;
		for (const res of resolvedEntries) {
			let listItem = $("<li>");
			listItem.append("<span class='property-value'>" + __util.asLinkIfLink(res.resolvedKey ? res.resolvedKey : res.query, ' <i class="bi bi-box-arrow-up-right"></i>', "_BLANK") + "</span>");
			warning = this.showResolvedVocabularyEntry(res, listItem) || warning;

			listItem.append(" (" + res.path + ")");

			$("#import-resolved-values ul").append(listItem);
		}
		$("#import-resolved-values").parent(".accordion-item").find(".accordion-header .bi").addClass("text-" + (warning ? "warning" : "info") );
		
		$("#import-resolved-values").parent(".accordion-item")
			.show()
			.find(".message-count").text(resolvedEntries.length).removeClass("bg-info").removeClass("bg-warning").addClass("bg-" + (warning ? "warning" : "info"));
	}
}

ImportForm.prototype.showResolvedVocabularyEntry = function(res, listItem) {
	let message;
	let color;
	if (res.resolved) {
		message = __translator.translate("view.import.messages.import_result.vocabulary.matched_and_set_candidate");
		$(listItem).find(".property-value").prepend("<span class='property-resolved-value'>" + res.query + "</span> &rarr; ");
		color = "info";
	} else if (res.candidateCount > 0) {
		message = __translator.translate("view.import.messages.import_result.vocabulary.too_many_candidates");
		$(listItem).find(".property-value").append(" &rarr; <span class='property-resolved-value'>" + __translator.translate("view.import.messages.import_result.vocabulary.too_many_candidates") + "</span>");
		color = "warning";
	} else {
		message = __translator.translate("view.import.messages.import_result.vocabulary.no_candidates_to_choose_from");
		$(listItem).find(".property-value").append(" &rarr; <span class='property-resolved-value'>" + __translator.translate("view.import.messages.import_result.vocabulary.no_candidates_to_choose_from") + "</span>");
		color = "warning";
	}

	$(listItem).prepend('<i class="bi bi-database cursor-hand text-' + color + '" ' + 
							'onclick="importForm.triggerManualResolve(this);return false;"' +
							'data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="custom-tooltip-' + color + '" ' + 
							'data-bs-title="' + message + '"></i> ');
							
	$(listItem).data("resolve-vocabulary", res.vocabulary);
	$(listItem).data("resolve-query", res.query);
	$(listItem).data("resolve-candidates", res.candidateCount);
	$(listItem).data("resolve-resolved", res.resolved);
	if (res.resolvedKey) {
		$(listItem).data("resolve-key", res.resolvedKey);
	}
	return color=="warning";
}