var entityTable;

$(document).ready(function() {
	entityTable = new EntityTable({
		url: __util.composeUrl("api/v1/" + $("#entity-table").data("api-url") + "/"),
		definition: $("#entity-table").data("definition"),
		drafts: $("#entity-table").data("drafts"),
		templates: $("#entity-table").data("templates")
	});
});


class EntityTable extends BaseTable {
	constructor(options) {
		super($.extend(true, {
				containerSelector: "#entity-table-container",
				selector: "#entity-table",
				initMaxColumns: 5,
				includeExportButtons: true,
				includeSearchPane: true,
				includeColumnReorder: true,
				clickRowEvent: true,
				buttons: []
			}, options),
	        	[
	        		"view.dialog.na",
					"view.dialog.true",
					"view.dialog.false",
					"model.generic.state.readOnly",
					"model.generic.state.draft",
					"model.generic.state.imported",
					"model.generic.state.deleted",
					"model.generic.state.published",
					"model.generic.state.template",
					"view.model.action.new_entity",
					"view.model.action.remove_own_drafts",
					"view.dialog.drafts.remove_own_drafts",
					
					"view.dialog.generic.delete_succeeded",
					"view.dialog.generic.delete_failed"					
            	]
	        );
        
        const _this = this;
        this.initTranslations(function() {
			_this.addButtons();
			_this.applyBaseSettings();
            _this.createTable();
        });
    }
    
    addButtons() {
		const _this = this;
		if (__auth.isAuthenticated() && this.options.definition) {
			this.options.buttons.push({
				text: this.renderButtonTitle('add', "view.model.action.new_entity"),
				className: 'btn btn-primary',
				action: function(e, dt, node, config) {
					window.location = __util.composeUrl("entity/new/" + _this.options.definition + "/");
				}
			})
		}
		if (__auth.isAuthenticated() && this.options.drafts) {
			this.options.buttons.push({
				text: this.renderButtonTitle('remove', "view.model.action.remove_own_drafts"),
				className: 'btn btn-danger',
				action: function(e, dt, node, config) {
					_this.deleteDrafts();
				}
			})
		}
	}
    
    deleteDrafts() {
		const _this = this;
		bootbox.confirm({
            message: __translator.translate('view.dialog.drafts.remove_own_drafts'),
            locale: "current",
            callback: function(result) {
                if (result) {
                    $.ajax({
			            type: "DELETE",
			            url: __util.composeUrl("api/v1/drafts"),
			            success: function() {
			                __util.showAlert("info", __translator.translate("view.dialog.generic.delete_succeeded"));
			                _this.refresh();
			            },
			            error: function(jqXHR, textStatus, errorThrown) {
			                if (jqXHR?.responseJSON) {
			                    __util.showAlert("danger", __translator.translate("view.dialog.generic.delete_failed"));
			                }
			            },
			            dataType: "json"
			        });
                }
            }
        });
	}
    
	createTable() {
		const _this = this;
		let columns;
		if (this.options.url) {
	        columns = this.createDynamicColumns({
				"targets": [0],
				"data": function(row, type, val, meta) { return _this.renderStateColumn(row, type, val, meta); },
			});
        } 
        this.createDatatable(columns);
    }
	
	handleRowClick(data) {
		window.location = __util.composeUrl("entity/" + data.entityId + "/");
	}
	
	renderStateColumn(row, type, val, meta) {
		const properties = [
			   { property: "template", type: "primary" }, 
			   { property: "draft", type: "warning" }, 
			   { property: "published", type: "primary" }, 
			   { property: "readOnly", type: "info" }, 
			   { property: "deleted", type: "danger" }, 
			   { property: "imported", type: "info", render: function(row) { return row.importId?.length > 0 } }
		]
		return this.renderStateProperties(properties, row, type=="display");
	}
	
	renderStateProperties(properties, row, display) {
		let result = "";
		for (let prop of properties) {
			let hasProp = false;
			if (prop.render && typeof prop.render == 'function') {
				hasProp = prop.render(row);
			}
			if (hasProp || (row.hasOwnProperty(prop.property)) && row[prop.property]==true) {
				if (display) {
					result += '<span class="badge bg-' + prop.type + '">' + __translator.translate("model.generic.state." + prop.property) + '</span> ';
				} else {
					result += __translator.translate("model.generic.state." + prop.property) + ' ';
				}
			}
		}
		return result;
	}
};