var ObjectTable = function(options) {
	this.options = $.extend(true, 
			{
				// Should be overriden
				container: null, 
				//tableSelector: ".editor-table",
				newRowUrl: "?",
				newRowCallback: null,
				initCallback: null,
				propertyName: "?",
				
				// Defaults should be ok
				attributeNameHelperSelector: ".attribute-name-helper",
				listRowSelector: "tr.list",
				editRowSelector: "tr.edit",
				pushUpButtonSelector: ".btn-objecttable-push-up",
				pushDownButtonSelector: ".btn-objecttable-push-down",
			}, 
			options);
	
	this.table = this.options.container;
	
	var _this = this;
	this.sort();
	
	if (this.options.initCallback!==null && typeof _this.options.initCallback==='function') {
		this.options.initCallback(this);
	}
}

ObjectTable.prototype.updatePreviewItem = function(property, value) {
	this.table.find("tr.list td").each(function() {
		if ($(this).attr("aria-property-preview")==property) {
			$(this).text(value);
		}
	});
};

ObjectTable.prototype.getNameFromPropertyNameAndIndex = function(index, prevName) {
	return this.options.propertyName + '[' + index + ']' + prevName.substring(prevName.indexOf('.'));
};

ObjectTable.prototype.getIdFromPropertyNameAndIndex = function(index, prevName) {	
	return this.options.propertyName + index + prevName.substring(prevName.indexOf('.'));
};

ObjectTable.prototype.sort = function() {
	let _this = this;
	let index = 0;
	
	this.table.find(this.options.listRowSelector).each(function() {
		// Update preview placeholders
		$(this).find(".property-preview").each(function() {
			$(this).data("property-preview", _this.getNameFromPropertyNameAndIndex(index, $(this).data("property-preview")));
			$(this).attr("aria-property-preview", _this.getNameFromPropertyNameAndIndex(index, $(this).data("property-preview")));
		});
		index++;
	});
	index = 0;
	this.table.find(this.options.editRowSelector).each(function() {
		// Update form controls
		$(this).find(".form-control, .form-control-container").not(".tt-hint").each(function() {
			let subprop = $(this).data("subprop");
			let name = _this.getNameFromPropertyNameAndIndex(index, $(this).prop("name") + (subprop==undefined ? '' : '#' + subprop));
			let id = _this.getIdFromPropertyNameAndIndex(index, $(this).prop("id") + (subprop==undefined ? '' : '#' + subprop));
			$(this).prop("id", id).prop("name", name);
		});
		
		// Remove value tables and reindex (init of value tables after sort is complete)
		$(this).find(".property-container").each(function() {
			let propertyListIdentifier = $(this).data("property-identifier"); 
			let propertyListName = $(this).data("property-container"); 
			
			// Remove all value lists within sorted area and re-init with updated property
			_this.options.owner.removeValueList( propertyListIdentifier );
			
			propertyListName = _this.getNameFromPropertyNameAndIndex(index, propertyListName);
			$(this).data("property-container", propertyListName);
		});
		
		// Update labels
		$(this).find("label[for^='" + _this.options.propertyName + "']").each(function() {
			$(this).prop("for", _this.getNameFromPropertyNameAndIndex(index, $(this).prop("for")));
		});		
		index++;
	});
	
	index = 0;
	// init of value tables in dedicated step
	this.table.find(this.options.editRowSelector).each(function() {
		$(this).find(".property-container.property-value-list").each(function() {
			let propertyListName = $(this).data("property-container"); 
			_this.options.owner.initValueList(this, propertyListName);
		});
		index++;
	});
	
	index=0;
	let lastRow = null;
	this.table.find(this.options.listRowSelector).each(function() {
		$(this).find(_this.options.pushDownButtonSelector).addClass("disabled");
		if (index==0) {
			$(this).find(_this.options.pushUpButtonSelector).addClass("disabled");
		} else {
			$(this).find(_this.options.pushUpButtonSelector).removeClass("disabled");
		}
		if (lastRow!=null) {
			$(lastRow).find(_this.options.pushDownButtonSelector).removeClass("disabled");
		}
		lastRow = $(this);
		index++;
	});
}

ObjectTable.prototype.triggerAddTableElement = function() {
	var _this = this;
	$.ajax({
        url: _this.options.newRowUrl,
        type: "GET",
        data: {
			path: _this.options.propertyName
		},
        dataType: "html",
        success: function(data) {
        	var r = $(data);
        	_this.addNewEntry(r);
        	if (_this.options.newRowCallback!==null && typeof _this.options.newRowCallback==='function') {
        		_this.options.newRowCallback(r, _this);
        	}
        	_this.table.find("select").trigger("change");
        	
        },
        error: function(textStatus) { }
	});
};

ObjectTable.prototype.addNewEntry = function(rows) {
	this.hideAllEdit();
	
	// Insert new rows before button row
	this.table.find("tbody").append(rows);
	this.table.addClass("has-data");
		
	this.sort();
	this.expandLastEdit();
}

ObjectTable.prototype.editEntry = function(btn) {
	// Toggle open
	let expand = $(btn).closest("tr").next().css("display")=="none";
	this.hideAllEdit();
	if (expand) {
		let expanded = $(btn).closest("tr");
		expanded.addClass("row-open table-primary");
		expanded.next().show().addClass("row-open table-primary");
	}
};

ObjectTable.prototype.removeEntry = function(btn) {
	$(btn).closest("tr").next().remove();
	$(btn).closest("tr").remove();
	
	if (this.table.find("tbody tr").length==0) {
		this.table.removeClass("has-data");
	}
	
	this.sort();
};

ObjectTable.prototype.pushEntryUp = function(btn) {
	let prevEntry = $(btn).closest("tr").prevAll(this.options.listRowSelector).first();
	
	if (prevEntry.length>0) {
		let editEntry = $(btn).closest("tr").next().detach();
		let listEntry = $(btn).closest("tr").detach();
		
		prevEntry.before(listEntry);
		prevEntry.before(editEntry);
		
		this.sort();
	}
};

ObjectTable.prototype.pushEntryDown = function(btn) {
	let nextEntry = $(btn).closest("tr").next().nextAll(this.options.editRowSelector).first();
	
	if (nextEntry.length>0) {
		let editEntry = $(btn).closest("tr").next().detach();
		let listEntry = $(btn).closest("tr").detach();
		
		nextEntry.after(editEntry);
		nextEntry.after(listEntry);
		
		this.sort();
	}
};

ObjectTable.prototype.handleInputChange = function(input, field, value, useHtml) {
	/*let listRow = $(input).closest("tr").prev();
	listRow.find("." + field).each(function() {
		
		console.log(this);
		
		if (value===undefined) {
			value = $(input).val();
		} 
		if (useHtml===true) {
			$(this).html(value);
		} else {
			$(this).text(value);
		}
	});*/
};

ObjectTable.prototype.handleSelectChange = function(select, field) {
	/*let listRow = $(select).closest("tr").prev();
	listRow.find("." + field).each(function() { 
		console.log(this);
		$(this).text($(select).find("option:selected").text());
	});*/
};

ObjectTable.prototype.hideAllEdit = function() {
	this.table.find(this.options.editRowSelector).hide();
	this.table.find("tr").removeClass("row-open table-primary");
};

ObjectTable.prototype.expandLastEdit = function() {
	let expanded = this.table.find(this.options.editRowSelector).last();
	expanded.css("display","").addClass("row-open table-primary");
	expanded.prev().addClass("row-open table-primary");
	
	expanded.find(".form-control").first().focus();
}