let entityForm;
$(document).ready(function() {
	entityForm = new EntityForm();
});

const EntityForm = function() {
	const _this = this;
	this.uniqueId = $("#uniqueId").val();
	this.entityDefinition = $("#def").val();
	this.entityId = $("#entity-form").data("entity");

	this.entryTypeahead = new EntryTypeahead();

	__translator.addTranslations([		
		"view.entity_form.messages.no_change_no_save",
		"view.entity_form.messages.saved",
		"view.entity_form.messages.validation_result.validation_errors",
		"view.entity_form.messages.validation_result.validated",
		
		"view.entity_form.typeahead.no_results_add_free",
		"view.entity_form.typeahead.no_results"
	]);
	__translator.getTranslations();

	$("#entity-form").on("submit", function(event) {
		_this.submitData();
		event.preventDefault();
	});
	
	$('.entity-form-sidebar-propertyblock a').click(function(e){
	  const element = $($(this).data("link"));
	  $('html, body').animate({
	        scrollTop: $(element).offset().top - $("#entity-form-head").outerHeight() - 8
	    }, 500);
	})
	
	this.initEditorComponents();
	this.entryTypeahead.initTypeahead($("#entity-form"));
};

EntityForm.prototype.createComposite = function() {
	const _this = this;
	$.ajax({
		type: "POST",
		url: __util.composeUrl("api/v1/c/" + (_this.entityId!==undefined ? _this.entityId: "")),
		/*data: JSON.stringify(formData),
		contentType: "application/json; charset=UTF-8",*/
		//headers: headers,
		success: function(data) {
			if ( data.action=="CREATED" || data.action=="UPDATED") {
				window.location.replace(__util.composeUrl("entity/" + data.item.uniqueId + "/"));
			} /*
			  // Required because autopopulation might set properties that were not submitted
			else if (data.action=="UPDATED") {
				_this.showAlert("success", __translator.translate("view.entity_form.messages.saved"));
			}*/ else if (data.action=="UNCHANGED") {
				_this.showAlert("primary", __translator.translate("view.entity_form.messages.no_change_no_save"));
				_this.processValidationResult(data);
			} else if (data.action=="VALIDATED") {
				_this.showAlert("success", __translator.translate("view.entity_form.messages.validation_result.validated"));
				_this.processValidationResult(data);
			}
		},
		error: function(jqXHR, textStatus, errorThrown) {
			if (jqXHR!==undefined && jqXHR.responseJSON!==undefined) {
				_this.showAlert("danger", __translator.translate("view.entity_form.messages.validation_result.validation_errors"));
				_this.processValidationResult(jqXHR.responseJSON);	
			}
		},
		dataType: "json"
	});
}

EntityForm.prototype.submitData = function(options) {
	options = $.extend(true, {
				validateOnly: false,
				draft: false,
				publish: false,
				template: false
			}, options);
			
	for (const list of this.lists) {
		list.sort();
	}
	for (const table of this.tables) {
		table.sort();
	}
			
	const formData = $(".form-body-element").serializeArray();
	const headers = {};
	if (options.validateOnly===true) {
		headers["Entity-Validate-Only"] = true;
	}
	if (options.draft===true) {
		headers["Entity-Save-Draft"] = true;
	}
	if (options.publish===true) {
		headers["Entity-Save-Published"] = true;
	}
	if (options.template===true) {
		headers["Entity-Save-Template"] = true;
	}

	const _this = this;
	$.ajax({
		type: "POST",
		url: __util.composeUrl("api/v1/e/" + (_this.entityId!==undefined ? _this.entityId: "")),
		data: JSON.stringify(formData),
		contentType: "application/json; charset=UTF-8",
		headers: headers,
		success: function(data) {
			if ( data.action=="CREATED" || data.action=="UPDATED") {
				window.location.replace(__util.composeUrl("entity/" + data.item.uniqueId + "/"));
			} /*
			  // Required because autopopulation might set properties that were not submitted
			else if (data.action=="UPDATED") {
				_this.showAlert("success", __translator.translate("view.entity_form.messages.saved"));
			}*/ else if (data.action=="UNCHANGED") {
				_this.showAlert("primary", __translator.translate("view.entity_form.messages.no_change_no_save"));
				_this.processValidationResult(data);
			} else if (data.action=="VALIDATED") {
				_this.showAlert("success", __translator.translate("view.entity_form.messages.validation_result.validated"));
				_this.processValidationResult(data);
			}
		},
		error: function(jqXHR, textStatus, errorThrown) {
			if (jqXHR!==undefined && jqXHR.responseJSON!==undefined) {
				_this.showAlert("danger", __translator.translate("view.entity_form.messages.validation_result.validation_errors"));
				_this.processValidationResult(jqXHR.responseJSON);	
			}
		},
		dataType: "json"
	});
	event.preventDefault();
};

EntityForm.prototype.discard = function() {
	// New entity -> back to list
	if (this.entityId===undefined) {
		window.location.replace(__util.composeUrl("entities/" + this.entityDefinition + "/"));
	} else {
		document.forms['entity-form'].reset();
		window.location.reload();
	}
}

EntityForm.prototype.toggleHelpTexts = function(button) {
	if ($(button).hasClass("active")) {
		$(button).removeClass("active");
		$(".editor-hint").addClass("d-none");
	} else {
		$(button).addClass("active");
		$(".editor-hint").removeClass("d-none");
	}
}

EntityForm.prototype.showAlert = function(alertType, body) {
	$("#notifications-area").html(
		'<div class="alert alert-' + alertType + ' alert-dismissible fade show" role="alert">' + 
			body +
			'<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>' + 
		'</div>');
}	

EntityForm.prototype.deleteEntity = function() {
	const _this = this;
	$.ajax({
		type: "DELETE",
		url: __util.composeUrl("api/v1/e/" + _this.uniqueId),
		success: function(data) {
			if (data.action=="DELETED") {
				window.location.replace(__util.composeUrl("entities/" + _this.entityDefinition + "/"));
			} 
		}
	});
};

EntityForm.prototype.processValidationResult = function(data) {
	const errorDetails = data?.errorDetails || [];
	
	// Remove red background from all table rows
	$("#entity-form tr").removeClass("table-danger");
	
	$("#entity-form label").each(function() {
		$(this).removeClass("text-danger")
		for (let detail of errorDetails) {
			// equals {name} or starts with {name}. or starts with {name}[
			if ( (detail.name==$(this).prop("for")) || (detail.name.startsWith($(this).prop("for") + '.')) || (detail.name.startsWith($(this).prop("for") + '[')) ) {
				$(this).addClass("text-danger")
			}
		}
	});
	
	$("#entity-form-sidebar .entity-form-sidebar-propertyblock h3 a").removeClass("text-danger");
	$("#entity-form-sidebar a").each(function() {
		$(this).removeClass("text-danger")
		for (let detail of errorDetails) {
			// equals {name} or starts with {name}. or starts with {name}[
			if ( (detail.name==$(this).data("path")) || (detail.name.startsWith($(this).data("path") + '.')) || (detail.name.startsWith($(this).data("path") + '[')) ) {
				$(this).addClass("text-danger")
				$(this).closest(".entity-form-sidebar-propertyblock").find("h3 a").addClass("text-danger")
			}
		}
	});
	
	$("#entity-form .hierarchical-property-container").each(function() {
		$(this).children(".invalid-feedback").hide().text('');
		for (let detail of errorDetails) {
			if (!detail.highlighted && detail.name==$(this).data("property-container")) {
				$(this).children(".invalid-feedback").show().append(detail.message);
				detail.highlighted = true;
			}
		}
	});
		
	$("#entity-form .property-container").each(function() {
		$(this).find(".invalid-feedback").hide().text('');
		$(this).find(".form-body-element").addClass("is-valid").removeClass("is-invalid");
		
		for (let detail of errorDetails) {
			if (detail.highlighted===true) {
				continue;
			}

			detail.highlighted = false;
			
			$(this).find(".form-body-element").each(function() {
				if (!detail.highlighted && $(this).prop("name")==detail.name && $(this).closest(".property-value-list-item").find(".invalid-feedback").length>0) {
					fail = true;
					detail.highlighted = true;
					
					$(this).removeClass("is-valid").addClass("is-invalid");
					$(this).closest(".property-value-list-item").find(".invalid-feedback").show().append(detail.message);
					$(this).parents("tr.edit").prev().addClass("table-danger");
				}
			});
			
			if (!detail.highlighted && detail.name==$(this).data("property-container")) {
				$(this).find(".form-body-element").removeClass("is-valid").addClass("is-invalid");
				$(this).children(".invalid-feedback").show().append(detail.message);
				detail.highlighted = true;
			}
		}
	});
	
	$("#entity-invalid-feedback").each(function() {
		for (let detail of errorDetails) {
			if (detail.highlighted===true) {
				continue;
			}
			$(this).show().append('<li><strong>' + detail.name + "</strong>: " + detail.message + '</li>');
			detail.highlighted = true;
		}
	});
}

EntityForm.prototype.handleInputChange = function(control) {
	const container = $(control).closest(".property-container").first();
	const valueProperty = container.data("property-container");
	
	const object = $(control).parents(".property-object-list").first();
	const objectProperty = object.data("property-container");
	
	if ($(control).prop("type")==="radio" && $(control).hasClass("vocabulary-match-option")) {
		this.handleVocabularyMatchOptionChange(control);
	}
		
	let value = "";
	$(container).find(".form-control").not(".disabled").each(function() {
		let elemVal;
		
		
		if ($(this).hasClass("typeahead")) {
			elemVal = $(this).typeahead('val');
		} 
		
		if (elemVal==undefined) {
			elemVal = $(this).val();
		}
		if (elemVal.length>0) {
			value = value + (value==="" ? "" : ", ") + elemVal;
		}
	});
	
	const row = $(control).closest("tr.edit");
	// Only changes within object tables are currently relevant
	if (row.length>0) {
		this.handleObjectPropertyValueChange(objectProperty, valueProperty, value);
	}	
};

EntityForm.prototype.handleObjectPropertyValueChange = function(object, property, value) {
	const i = this.tables.findIndex((i) => { return i.options.propertyName===object; });
	const table = this.tables[i];
	
	table.updatePreviewItem(property, value);
};

EntityForm.prototype.handleVocabularyMatchOptionChange = function(control) {
	// Disable all
	$(control).parents(".form-vocabulary-selection").first().find(".form-control")
		.prop("disabled", true)
		.addClass("disabled")
		.removeAttr("name", false);
	
	// Enable next
	$(control).next()
		.prop("disabled", false)
		.removeClass("disabled")
		.attr("name", $(control).data("property-name"));
}

EntityForm.prototype.addControl = function(container) {
	let items = $(container).find('.property-values');//$(this).data('property-identifier')
	let propertyIdentifier = items.data('property-identifier');
}

EntityForm.prototype.removeObjectTable = function(name) {
	const i = this.tables.findIndex((i) => { return i.options.propertyName===name; });
	if (i<0) {
		return;
	}
	this.tables.splice(i, 1);
};

EntityForm.prototype.removeValueList = function(identifier) {
	for (let i=this.lists.length-1; i>=0; i--) {
		if (this.lists[i].options.propertyIdentifier===identifier) {
			this.lists.splice(i, 1);
		}
	}
};

EntityForm.prototype.clearAll = function(control) {
	const property = $(control).closest(".property-value-list").data("property-container");
	const i = this.lists.findIndex((i) => { return i.options.propertyName===property; });
	
	if (i>=0) {
		this.lists[i].clearAll();
	} else {
		const container = $(control).closest(".property-container"); 
		$(container).find(":text").val("");
		$(container).find("textarea").val("");
		$(container).find(":checkbox").prop("checked", false);
		$(container).find(":radio").prop("checked", false);
	}
}

EntityForm.prototype.findList = function(control) {
	const property = $(control).closest(".property-value-list").data("property-container");
	const i = this.lists.findIndex((i) => { return i.options.propertyName===property; });
	return this.lists[i];
};

EntityForm.prototype.findTable = function(control) {
	const property = $(control).closest(".property-object-list").data("property-container");
	const i = this.tables.findIndex((i) => { return i.options.propertyName===property; });
	return this.tables[i];
};

EntityForm.prototype.initValueList = function(container, propertyName) {
	const _this = this;
	let property = $(container).data("property-container");
	let identifier = $(container).data("property-identifier");
	
	if (propertyName==undefined || propertyName==null || propertyName==property) {
		_this.lists.push(new ValueList({
			container: $(container),
			propertyName: property,
			owner: _this,
			propertyIdentifier: identifier,
			newRowUrl: __util.composeUrl("entity/includes/" + $(container).data("property-identifier")),
			newRowCallback: function(row) {
				_this.entryTypeahead.initTypeahead(row);
			}
		}));
	}
};

EntityForm.prototype.initObjectTable = function(container, propertyName) {
	const _this = this;
	let property = $(container).data("property-container");
	if (propertyName==undefined || propertyName==null || propertyName==property) {
		_this.tables.push(new ObjectTable({
			container: $(container),
			propertyName: property,
			owner: _this,
			newRowUrl: __util.composeUrl("entity/includes/" + $(container).data("property-identifier")),
			newRowCallback: function(row) {
				_this.entryTypeahead.initTypeahead(row);
			}
		}));
	}
};

EntityForm.prototype.initEditorComponents = function() {
	const _this = this;
	
	this.lists = [];
	this.tables = [];
	
	$('.property-value-list').filter(function() {
	    return $(this).closest(".property-object-list").length==0;
	}).each(function() {
		_this.initValueList(this);
	});
	
$(".property-object-list").each(function() { _this.initObjectTable(this); });
}