var _csrf = $('meta[name=_csrf]').attr("content");
var _csrfHeader = $('meta[name=_csrf_header]').attr("content");

/*$.ajaxSetup({
    beforeSend: function(xhr, settings) {
        if (settings.type == 'POST' || settings.type == 'PUT' || settings.type == 'DELETE') {
        	xhr.setRequestHeader(_csrfHeader, _csrf);
        }
    }
});*/

/* 
 * Mainly for Safari support
 * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/bind
 */
if (!Function.prototype.bind) {
	  Function.prototype.bind = function (oThis) {
	    if (typeof this !== "function") {
	      // closest thing possible to the ECMAScript 5 internal IsCallable function
	      throw new TypeError("Function.prototype.bind - what is trying to be bound is not callable");
	    }

	    var aArgs = Array.prototype.slice.call(arguments, 1),
	        fToBind = this,
	        fNOP = function () {},
	        fBound = function () {
	          return fToBind.apply(this instanceof fNOP && oThis
	                                 ? this
	                                 : oThis,
	                               aArgs.concat(Array.prototype.slice.call(arguments)));
	        };

	    fNOP.prototype = this.prototype;
	    fBound.prototype = new fNOP();

	    return fBound;
	  };
}


if (!String.format) {
        String.format = function(format) {
                var args = Array.prototype.slice.call(arguments, 1);
                if (format!==null && format!==undefined) {
	                return format.replace(/{(\d+)}/g, function(match, number) {
	                        return typeof args[number] != 'undefined' ? args[number] : match;
	                });
                } else {
                	return format;
                }
        };
}

String.prototype.endsWith = function(suffix) {
    return this.indexOf(suffix, this.length - suffix.length) !== -1;
};

String.prototype.startsWith = function(start) {
        return this.length >= start.length && this.substr(0,start.length)==start;
};

String.prototype.replaceAll = function (find, replace) {
    var str = this;
    return str.replace(new RegExp(find.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'), 'g'), replace);
};

var Util = function() {
	__translator.addTranslations([
		"view.error.generic.head",
		"view.error.item_not_found"
	]);
        // We depend on the view's main js for this call
    //__translator.getTranslations();
        this.entityMap = {
                "&" : "&amp;",
                "<" : "&lt;",
                ">" : "&gt;",
                '"' : '&quot;',
                "'" : '&#39;',
                "/" : '&#x2F;'
        };
        
    // //https://www.freecodecamp.org/news/check-if-a-javascript-string-is-a-url/
	this.urlPattern = new RegExp('^(https?:\\/\\/)?'+ // validate protocol
	    '((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|'+ // validate domain name
	    '((\\d{1,3}\\.){3}\\d{1,3}))'+ // validate OR ip (v4) address
	    '(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*'+ // validate port and path
	    '(\\?[;&a-z\\d%_.~+=-]*)?'+ // validate query string
	    '(\\#[-a-z\\d_]*)?$','i'); // validate fragment locator
};
var __util = new Util();

Util.prototype.escapeHtml = function(string) {
        var _this = this;
        return String(string).replace(/[&<>"'\/]/g, function(s) {
                return _this.entityMap[s];
        });
};

Util.prototype.showLoginNote = function(redirectUrl) {
    bootbox.dialog({
        message : __translator.translate("~eu.dariah.de.colreg.common.view.notifications.login_required.body"),
        title : __translator.translate("~eu.dariah.de.colreg.common.view.notifications.login_required.head"),
        buttons : {
            no : {
                label : __translator.translate("~eu.dariah.de.colreg.common.link.no"),
                className : "btn-default"
            },
            yes : {
                label : __translator.translate("~eu.dariah.de.colreg.common.link.yes"),
                className : "btn-primary",
                callback : function() {
					if (redirectUrl!=undefined && redirectUrl!=null) {
                        window.location = redirectUrl;
					} else {
						window.location = $(".account_toggle").prop("href");
					}
                }
            }
        }
    });
};

Util.prototype.showErrorResponse = function(response, type) {
	let message;
	if (response.message.toLowerCase()=="item_not_found") {
		message = __translator.translate("view.error.item_not_found");
	} else {
		message = response.message + " (Code: " + response.status + ")"
	}
	
	if ($("#notifications-area").length>0) {
		this.showAlert(type==undefined ? "warning" : type, message);
	} else {
		bootbox.alert({
		  title: __translator.translate("view.error.generic.head"),
		  message: message
	});
	}	
};

Util.prototype.showAlert = function(alertType, body, customSelector) {
	let selector = "#notifications-area";
	if (customSelector) {
		selector = customSelector; 
	}
	$(selector).html(
		'<div class="alert alert-' + alertType + ' alert-dismissible fade show" role="alert">' + 
			body +
			'<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>' + 
		'</div>');
}

Util.prototype.isLoggedIn = function() {
        var loggedIn = false;
        $.ajax({
        url: __util.getBaseUrl() + "async/isAuthenticated",
        type: "GET",
        async: false,
        encoding: "UTF-8",
        dataType: "text",
        success: function(data) {
                loggedIn = (data=="true");
        }
        });
       
        if (loggedIn) {
                $("#login").css("display", "none");
                $("#logout").css("display", "block");
        } else {
                $("#login").css("display", "block");
                $("#logout").css("display", "none");
        }
        return loggedIn;       
};

Util.prototype.getBaseUrl = function() {
        return $("#baseUrl").val();
};

Util.prototype.composeUrl = function(target) {
    return $("#baseUrl2").val().replace("{}", target);
};

Util.prototype.asLinkIfLink = function(urlString, suffixHtml, target, classes) {
	return urlString;
	// TODO: Too much recursion
	if (this.urlPattern.test(urlString)) {
		const link = $("<a>");
		$(link).prop("href", urlString);
		if (target) {
			$(link).prop("target", target);
		}
		if (classes) {
			$(link).addClass(classes);
		}
		$(link).append(urlString);
		if (suffixHtml) {
			$(link).append(suffixHtml);
		}
		return $(link).prop('outerHTML');
	} else {
		return urlString;
	}
}

Util.prototype.syntaxHighlightJson = function(json) {
    if (typeof json != 'string') {
         json = JSON.stringify(json, undefined, 2);
    }
    json = json.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
    return json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g, function (match) {
        var cls = 'number text-info';
        if (/^"/.test(match)) {
            if (/:$/.test(match)) {
                cls = 'key text-primary';
            } else {
                cls = 'string text-danger';
            }
        } else if (/true|false/.test(match)) {
            cls = 'boolean text-info';
        } else if (/null/.test(match)) {
            cls = 'null text-info';
        }
        return '<span class="' + cls + '">' + match + '</span>';
    });
}
