class EntryTypeahead {
    constructor(options) {
		this.options = $.extend(true, 
			{
				suggestionsLimit: 10,
				cache: false,
				highlight: true,
				minQueryLength: 3
			}, 
			options);
			
        this.typeaheadSources = {};
    }
    
    initTypeahead(parent) {
        let _this = this;

        $(parent).find(".typeahead").each(function() {
            const vocabulary = $(this).data("vocabulary");
            const entity = $(this).data("vocabulary-entity");
            const strict = $(this).data("strict");

            const sourceId = (entity ? "e_" : "v_") + vocabulary;
            const sourceUrl = 'api/v1/' + (entity ? "e/" : "v/") + vocabulary + '/search';
			const getUrl = 'api/v1/' + (entity ? "e/" : "v/") + vocabulary + '/get';

			$(this).data("geturl", getUrl);
			
			const displayField = entity ? "entityId" : "key";
			$(this).data("geturl", getUrl);
			$(this).data("displayField", displayField);

			_this.createTypeahead(this, sourceId, sourceUrl, displayField, strict);
			_this.setTypeaheadValue(this);
        });
    }

    createTypeahead(element, sourceId, sourceUrl, displayField, strict) {
		const _this = this;
		
		let typeaheadTemplates = {
			 empty: function() { return _this.renderTypeaheadEmpty(strict) },
             suggestion: function(data) { return _this.renderTypeaheadSuggestionInline(data) }
		}
		
		if (!strict) {
			typeaheadTemplates.footer = function() { return _this.renderTypeaheadEmpty() };
		}
				
		$(element).typeahead(
            {
                highlight: _this.options.highlight,
                minLength: _this.options.minQueryLength,
            }, {
                name: sourceId,
                source: _this.getOrCreateTypeaheadSource(sourceId, sourceUrl),
                display: displayField,
                limit: _this.options.suggestionsLimit*2, // Fix(2) for https://github.com/twitter/typeahead.js/issues/1686#issuecomment-546655910
                templates: typeaheadTemplates
            }
		);
		
		this.bindEvents(element);
	}

	bindEvents(element) {
		const _this = this;

		// Lost focus and content has changed
		$(element).on('typeahead:change', function(ev, suggestion) {
			_this.setTypeaheadValue(element);
		});
				
		// Suggestion selected
		$(element).on('typeahead:select', function(ev, suggestion) { _this.handleSuggestionSelected(this, suggestion)});
		$(element).on('typeahead:autocomplete', function(ev, suggestion) { _this.handleSuggestionSelected(this, suggestion)});
		
		// Loading
		$(element).on('typeahead:asyncrequest', function() {
			$(this).closest(".input-group").find(".input-group-text").html('<div class="spinner-border spinner-border-sm" role="status"><span class="visually-hidden">Loading...</span></div>');
		});
		$(element).on('typeahead:asyncreceive', function() {
			$(this).closest(".input-group").find(".input-group-text").html('<i class="bi bi-database"></i>');
		});
		$(element).on('typeahead:asyncreceive', function() {
			$(this).closest(".input-group").find(".input-group-text").html('<i class="bi bi-database"></i>');
		});
	};
	
	setTypeaheadValue(element) {
		const _this = this;
		const field = $(element).data("displayField");
		const val = $(element).typeahead('val');

		if (val === $(element).closest(".property-value-list-item, .property-container").find(".selected-suggestion .alert").data("selected-val")) {
			return;
		}
		
		$(element).closest(".property-value-list-item, .property-container").find(".selected-suggestion").text('');
		
		if (val.length==0) {
			return;
		}
		
		let requestData = { "ui" : true };
		requestData[field] = val;
		
		$.ajax({
			type: "POST",
			contentType: "application/json; charset=UTF-8",
			dataType: "json",
			url: __util.composeUrl($(element).data("geturl")),
			data: JSON.stringify(requestData),
			success: function(data) {
				 _this.handleSuggestionSelected(element, data.item, val);
			}
		});
	};
	
	handleSuggestionSelected(element, suggestion, freevalue) {
		if ($(element).hasClass("language-typeahead")) {
			return;
		}

		const val = $(element).typeahead('val');
		const prop = $(element).closest(".property-container").data("property-container");

		const listItem = $("<div class='mb-1 property-value-list-item'>");
		const flexContainer = $("<div class='d-flex'>");
		const checkbox = $("<input class='form-check-input form-body-element form-vocabulary-select-item' type='" + $(element).data("input-type") + "' name='" + prop + "' value='" + val + "' onchange='entityForm.findList(this).sort();'>");

		const labelContainer = $("<div class='flex-grow-1 form-vocabulary-select-label'>");
		const label = $("<label class='form-check-label w-100 ms-3'>");

		if ($(element).data("vocabulary-entity")) {
			//label.append("<a href='" + __util.composeUrl("entity/" + val + "/") + "' target='_blank'><i class='bi bi-database-add'></i></a> ");
			//label.append("<i class='bi bi-database-add'></i> ");
			//label.append("<i class='bi bi-plus'></i> ");
		}
		
		if (freevalue) {
			label.append(suggestion);
		} else {
			label.append(this.renderTypeaheadSuggestionInline(suggestion));
		}

		labelContainer.append(label);

		flexContainer
			.append(checkbox)
			.append(labelContainer);
					
		listItem.append(flexContainer);	

	  	$(element).closest(".property-container").children(".invalid-feedback").before(listItem);
	  	
	  	checkbox.prop("checked", true);
	  	
	  	$(element).typeahead('destroy');
		$(element).closest(".property-value-list-item").remove();
		
		if (entityForm) {
			entityForm.findList(checkbox).sort();
		}
	}

    getOrCreateTypeaheadSource(sourceId, sourceUrl) {
		const _this = this;
		if (!this.typeaheadSources.hasOwnProperty(sourceId)) {
			this.typeaheadSources[sourceId] = new Bloodhound({
				suggestionsLimit: _this.options.suggestionsLimit,
				datumTokenizer: Bloodhound.tokenizers.whitespace,
				queryTokenizer: Bloodhound.tokenizers.whitespace,
				remote: {
					url: __util.composeUrl(sourceUrl),
					cache: _this.options.cache,
					prepare: function(query, settings) {
						settings.type = "POST";
						settings.contentType = "application/json; charset=UTF-8";
						settings.data = JSON.stringify({ "query" : query, "ui" : true });
						return settings;
					},
					transform: function(response) {
						// Fix(1) for https://github.com/twitter/typeahead.js/issues/1686#issuecomment-546655910
						if (response.items.length > _this.options.suggestionsLimit) {
							return response.items.slice(0, _this.options.suggestionsLimit);
						} else {
							return response.items;
						}
					}
				}
			});
		}
		return this.typeaheadSources[sourceId];
	}
    
     
    renderTypeaheadSuggestionInline(data) {
		let displayVal = "";
		if (data._display) {
			 displayVal = data._display;
		} else {
			for (let i=0; i<data._view.length; i++) {
				let prop = data._view[i];
	            if (prop.value === undefined || prop.value === null) {
	                continue;
	            }
	            displayVal = displayVal + this.renderTypeaheadSuggestionValue(prop);
	            if (i<data._view.length-1) {
					displayVal += ", ";
				}
	        }
        }
        return "<span>" + displayVal + "</span>";
	}
    
    
    renderTypeaheadSuggestionValue(prop) {
        if (prop.value.values) {
            let value = "";
            for (let j = 0; j < prop.value.values.length; j++) {
                value = value + prop.value.values[j].value;
                if (j < prop.value.values.length - 1) {
                    value = value + ", ";
                }
            }
            return value;
        } else {
            return prop.value.value;
        }
    }
    
    renderTypeaheadEmpty(strict) {
		const _this = this;
		let empty = $("<div class='empty-message'>");
		if (!strict) {
			$(empty)
				.addClass("tt-suggestion tt-selectable")
				.text(__translator.translate("view.entity_form.typeahead.no_results_add_free"))
				.on("click", function(event) {
					_this.selectTypeaheadEmpty(this);
					event.preventDefault();
				});
		} else {
			$(empty).text(__translator.translate("view.entity_form.typeahead.no_results"));
		}
		return empty;
	}
	
	selectTypeaheadEmpty(empty) {
		const typeahead = $(empty).closest(".twitter-typeahead").find(".typeahead.tt-input");
		const val = $(typeahead).typeahead('val');
		this.handleSuggestionSelected(typeahead, val, true)
	}
}