/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.model;

import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.TextPropertyValue;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.view.model.BasePropertyViewItem;
import de.uniba.minf.registry.view.model.VocabularyPropertyViewItem;
import java.util.ArrayList;
import java.util.List;

public class SimplePropertyViewItem
extends BasePropertyViewItem {
    private final Property property;
    private VocabularyPropertyViewItem langPropertyViewItem;

    public SimplePropertyViewItem(PropertyDefinition definition, Property entity) {
        super(definition);
        this.property = entity;
    }

    public SimplePropertyViewItem(PropertyDefinition definition, Property entity, VocabularyPropertyViewItem langPropertyViewItem) {
        super(definition);
        this.property = entity;
        this.langPropertyViewItem = langPropertyViewItem;
    }

    public String getValueAsText() {
        if (this.property == null || this.property.getValue() == null) {
            return null;
        }
        return this.property.getValue().asText();
    }

    public List<PropertyValue> valuesAsList() {
        if (this.property != null && this.property.getValue() != null) {
            return this.property.valuesAsList();
        }
        return new ArrayList<PropertyValue>(1);
    }

    public List<String> valuesAsStringList() {
        return this.valuesAsList().stream().map(v -> v.asText()).toList();
    }

    public List<PropertyValue> valuesAsList(boolean includeEmptyPlaceholder) {
        if (!includeEmptyPlaceholder || this.property != null && this.property.getValue() != null) {
            return this.valuesAsList();
        }
        ArrayList<PropertyValue> emptyValuePlaceholderList = new ArrayList<PropertyValue>(1);
        emptyValuePlaceholderList.add((PropertyValue)new TextPropertyValue(""));
        return emptyValuePlaceholderList;
    }

    public Property getProperty() {
        return this.property;
    }

    public VocabularyPropertyViewItem getLangPropertyViewItem() {
        return this.langPropertyViewItem;
    }

    public void setLangPropertyViewItem(VocabularyPropertyViewItem langPropertyViewItem) {
        this.langPropertyViewItem = langPropertyViewItem;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimplePropertyViewItem)) {
            return false;
        }
        SimplePropertyViewItem other = (SimplePropertyViewItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property this$property = this.getProperty();
        Property other$property = other.getProperty();
        if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
            return false;
        }
        VocabularyPropertyViewItem this$langPropertyViewItem = this.getLangPropertyViewItem();
        VocabularyPropertyViewItem other$langPropertyViewItem = other.getLangPropertyViewItem();
        return !(this$langPropertyViewItem == null ? other$langPropertyViewItem != null : !this$langPropertyViewItem.equals(other$langPropertyViewItem));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimplePropertyViewItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        VocabularyPropertyViewItem $langPropertyViewItem = this.getLangPropertyViewItem();
        result = result * 59 + ($langPropertyViewItem == null ? 43 : $langPropertyViewItem.hashCode());
        return result;
    }

    public String toString() {
        return "SimplePropertyViewItem(super=" + super.toString() + ", property=" + this.getProperty() + ", langPropertyViewItem=" + this.getLangPropertyViewItem() + ")";
    }
}

