/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.model;

import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.PropertyValueList;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.view.model.PropertyViewItem;
import de.uniba.minf.registry.view.model.SimplePropertyViewItem;
import de.uniba.minf.registry.view.model.VocabularyPropertyViewItem;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;

public abstract class BasePropertyViewItem
implements PropertyViewItem {
    private final PropertyDefinition definition;
    private boolean readonly;

    public boolean isSimple() {
        return this.definition.isSimple();
    }

    public boolean isVocabulary() {
        return this.definition.isVocabulary();
    }

    public boolean isHierarchical() {
        return this.definition.isHierarchical();
    }

    public PropertyValue getValue() {
        if (this.isSimple()) {
            return this.getPropertyValue(((SimplePropertyViewItem)SimplePropertyViewItem.class.cast(this)).getProperty());
        }
        if (this.isVocabulary()) {
            return this.getPropertyValue(((VocabularyPropertyViewItem)VocabularyPropertyViewItem.class.cast(this)).getProperty());
        }
        return null;
    }

    public boolean isMultiValue() {
        PropertyValue value = this.getValue();
        return value != null && PropertyValueList.class.isAssignableFrom(value.getClass());
    }

    private PropertyValue getPropertyValue(Property entity) {
        return entity == null ? null : entity.getValue();
    }

    public String getUrlSafeLabel() {
        return URLEncoder.encode(this.definition.getName(), StandardCharsets.UTF_8);
    }

    public boolean allowsMultiplicity() {
        return this.getDefinition().isMultiple() || this.getDefinition().isMultilingual();
    }

    public boolean isValueList() {
        return this.allowsMultiplicity();
    }

    public List<PropertyValue> valuesAsList(boolean includeEmptyPlaceholder) {
        return this.valuesAsList();
    }

    public PropertyDefinition getDefinition() {
        return this.definition;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePropertyViewItem)) {
            return false;
        }
        BasePropertyViewItem other = (BasePropertyViewItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isReadonly() != other.isReadonly()) {
            return false;
        }
        PropertyDefinition this$definition = this.getDefinition();
        PropertyDefinition other$definition = other.getDefinition();
        return !(this$definition == null ? other$definition != null : !this$definition.equals(other$definition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasePropertyViewItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReadonly() ? 79 : 97);
        PropertyDefinition $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
        return result;
    }

    public String toString() {
        return "BasePropertyViewItem(definition=" + this.getDefinition() + ", readonly=" + this.isReadonly() + ")";
    }

    public BasePropertyViewItem(PropertyDefinition definition) {
        this.definition = definition;
    }
}

