/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.helper;

import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.HierarchicalPropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.view.helper.PropertyDefinitionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PropertyDefinitionHelper {
    private static final Logger log = LoggerFactory.getLogger(PropertyDefinitionHelper.class);

    public List<UnknownProperty> mergeWithDefinition(BaseDefinedObject e, BaseDefinition ed, boolean removeUnknown) {
        e.setDefinitionName(ed.getName());
        e.setDefinitionVersion(ed.getVersion());
        e.setPropertyDefinitions(ed.getAllProperties());
        ArrayList<UnknownProperty> unknownProperties = new ArrayList<UnknownProperty>();
        this.mergePropertiesWithDefinitions(ed.getName(), e.getProperties(), ed.getAllProperties(), removeUnknown, unknownProperties);
        return unknownProperties;
    }

    private void mergePropertiesWithDefinitions(String path, List<Property> ps, List<PropertyDefinition> pds, boolean removeUnknown, List<UnknownProperty> unknownProperties) {
        if (ps != null) {
            ArrayList removeProperties = new ArrayList();
            ps.stream().forEach(p -> {
                if (!this.mergePropertyWithDefinitions(path, p, pds == null ? Optional.empty() : pds.stream().filter(pd -> pd.getName().equals(p.getLabel())).findFirst(), removeUnknown, unknownProperties)) {
                    removeProperties.add(p);
                }
            });
            if (removeUnknown) {
                ps.removeAll(removeProperties);
            }
        }
    }

    private void mergePropertyListsWithDefinitions(String path, List<PropertyList> pls, List<PropertyDefinition> pds, boolean removeUnknown, List<UnknownProperty> unknownProperties) {
        pls.stream().filter(pl -> pl != null).forEach(pl -> {
            pl.setPropertyDefinitions(pds);
            this.mergePropertiesWithDefinitions(path, pl.getProperties(), pds, removeUnknown, unknownProperties);
        });
    }

    private boolean mergePropertyWithDefinitions(String path, Property p, Optional<PropertyDefinition> pd, boolean removeUnknown, List<UnknownProperty> unknownProperties) {
        String identifier = path + "." + p.getLabel();
        boolean result = true;
        if (pd.isEmpty()) {
            unknownProperties.add(new UnknownProperty(this, identifier, p.getLabel(), p.getValue() == null ? null : p.getValue().asText()));
            result = false;
        } else {
            p.setDefinition(pd.get());
        }
        if (p.getProperties() != null && pd.isPresent() && HierarchicalPropertyDefinition.class.isAssignableFrom(pd.get().getClass())) {
            this.mergePropertyListsWithDefinitions(identifier, p.getProperties(), ((HierarchicalPropertyDefinition)HierarchicalPropertyDefinition.class.cast(pd.get())).getProperties(), removeUnknown, unknownProperties);
        } else if (p.getProperties() != null) {
            this.mergePropertyListsWithDefinitions(identifier, p.getProperties(), new ArrayList(0), removeUnknown, unknownProperties);
        }
        return result;
    }

    public void removeDefinitionsFromEntities(List<Entity> entities) {
        entities.stream().forEach(arg_0 -> this.removeDefinitionsFromEntity(arg_0));
    }

    public void removeDefinitionsFromEntity(Entity entity) {
        entity.setPropertyDefinitions(null);
        this.removeDefinitionsFromProperties(entity.getProperties());
    }

    public void removeDefinitionsFromProperties(List<Property> properties) {
        if (properties == null) {
            return;
        }
        properties.stream().forEach(p -> {
            p.setDefinition(null);
            this.removeDefinitionsFromPropertyLists(p.getProperties());
        });
    }

    public void removeDefinitionsFromPropertyLists(List<PropertyList> propertyLists) {
        if (propertyLists == null) {
            return;
        }
        propertyLists.stream().forEach(p -> {
            p.setPropertyDefinitions(null);
            this.removeDefinitionsFromProperties(p.getProperties());
        });
    }
}

