/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.controller;

import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.view.controller.BaseViewController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/"})
public class HomeController
extends BaseViewController {
    public HomeController() {
        super("home");
    }

    @GetMapping(value={"/home", "/"})
    public String showHome(Model model, Locale locale) {
        Collection primaryDefinitions = this.getPrimaryEntityDefinitions();
        HashMap<EntityDefinition, Long> primaryDefinitionCountMap = new HashMap<EntityDefinition, Long>();
        for (EntityDefinition def : primaryDefinitions) {
            primaryDefinitionCountMap.put(def, this.entityRepository.countByDefinition(def.getName(), this.authInfoHelper.getAuth().isAuth()));
        }
        model.addAttribute("primaryDefinitionCountMap", primaryDefinitionCountMap);
        Collection secondaryDefinitions = this.getSecondaryEntityDefinitions();
        HashMap<EntityDefinition, Long> secondaryDefinitionCountMap = new HashMap<EntityDefinition, Long>();
        for (EntityDefinition def : secondaryDefinitions) {
            secondaryDefinitionCountMap.put(def, this.entityRepository.countByDefinition(def.getName(), this.authInfoHelper.getAuth().isAuth()));
        }
        model.addAttribute("secondaryDefinitionCountMap", secondaryDefinitionCountMap);
        return "home";
    }

    @GetMapping(value={"/vocabularies/{definitionName}/"})
    public String showVocabularyEntries(@PathVariable(value="definitionName") String definitionName, Model model, Locale locale) {
        VocabularyDefinition vocabularyDefinition = this.vocabularyDefinitionRepository.findCurrentByName(definitionName);
        model.addAttribute("vocabularyDefinition", (Object)vocabularyDefinition);
        model.addAttribute("previewProperties", (Object)vocabularyDefinition.getPreviewProperties());
        return "vocabularyEntries/list";
    }
}

