/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.service;

import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.BasePropertyValue;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.service.EntityCompositingService;
import de.uniba.minf.registry.service.EntityDefinitionService;
import de.uniba.minf.registry.view.helper.PropertyDefinitionHelper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityCompositingServiceImpl
implements EntityCompositingService {
    @Autowired
    private PropertyDefinitionHelper propertyDefinitionHelper;
    @Autowired
    private EntityDefinitionService entityDefinitionService;

    public Entity composeLayers(Entity e) {
        if (e.getLayers() == null || e.getLayers().isEmpty()) {
            return e;
        }
        EntityDefinition ed = this.entityDefinitionService.findByNameAndVersion(e.getDefinitionName(), e.getDefinitionVersion(), true);
        this.checkAndMergeWithDefinitions(e, ed);
        ArrayList composedProperties = e.getProperties();
        if (composedProperties == null) {
            composedProperties = new ArrayList();
        }
        for (int i = e.getLayers().size() - 1; i >= 0; --i) {
            this.composeProperties(composedProperties, (Entity)e.getLayers().get(i));
        }
        e.setProperties(composedProperties);
        return e;
    }

    private void composeProperties(List<Property> composedProperties, Entity layer) {
        if (layer.getProperties() == null) {
            return;
        }
        for (Property p : layer.getProperties()) {
            p.valuesAsList().forEach(v -> ((BasePropertyValue)BasePropertyValue.class.cast(v)).setLayerEntityId(layer.getEntityId()));
            composedProperties.add(p);
        }
    }

    private void checkAndMergeWithDefinitions(Entity e, EntityDefinition ed) {
        if (e.getPropertyDefinitions() == null || e.getPropertyDefinitions().isEmpty()) {
            this.propertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)e, (BaseDefinition)ed, true);
        }
        if (e.getLayers() != null && !e.getLayers().isEmpty()) {
            e.getLayers().stream().forEach(l -> this.checkAndMergeWithDefinitions(l, ed));
        }
    }
}

