/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.repository;

import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import de.uniba.minf.registry.repository.VocabularyEntryRepositoryCustom;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.TextIndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.TextCriteria;

public class VocabularyEntryRepositoryCustomImpl
implements VocabularyEntryRepositoryCustom,
InitializingBean {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoOperations mongoOperations;

    public void afterPropertiesSet() throws Exception {
        this.mongoOperations.indexOps(VocabularyEntry.class).ensureIndex((IndexDefinition)TextIndexDefinition.forAllFields());
    }

    public long countByDefinition(String definition) {
        return this.findByDefinition(definition).size();
    }

    public List<VocabularyEntry> findByDefinition(String definition) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"definitionName").is((Object)definition));
        return this.mongoTemplate.find(query, VocabularyEntry.class);
    }

    public List<VocabularyEntry> findByDefinitionAndQuery(String name, String query) {
        Query q = Query.query((CriteriaDefinition)Criteria.where((String)"definitionName").is((Object)name)).addCriteria((CriteriaDefinition)TextCriteria.forLanguage((String)"en").matching(query));
        return this.mongoTemplate.find(q, VocabularyEntry.class);
    }

    public void saveOrUpdate(VocabularyEntry e) {
        Query q = new Query();
        q.addCriteria((CriteriaDefinition)Criteria.where((String)"key").is((Object)e.getKey()).and("definitionName").is((Object)e.getDefinitionName()));
        VocabularyEntry eExist = (VocabularyEntry)this.mongoTemplate.findOne(q, VocabularyEntry.class);
        if (eExist != null) {
            e.setUniqueId(eExist.getUniqueId());
        }
        this.mongoTemplate.save((Object)e);
    }

    public void saveOrUpdateAll(List<VocabularyEntry> vocabularyEntries) {
        if (vocabularyEntries != null) {
            for (VocabularyEntry ve : vocabularyEntries) {
                this.saveOrUpdate(ve);
            }
        }
    }

    public void deleteByVocabularyName(String name) {
        Query q = new Query();
        q.addCriteria((CriteriaDefinition)Criteria.where((String)"definitionName").is((Object)name));
        this.mongoTemplate.remove(q, VocabularyEntry.class);
    }
}

