/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.importer;

import de.uniba.minf.core.rest.model.RestActionResponse;
import de.uniba.minf.registry.importer.ImportRunner;
import de.uniba.minf.registry.importer.ImportService;
import de.uniba.minf.registry.model.Import;
import de.uniba.minf.registry.model.ImportResult;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.ImportRepository;
import de.uniba.minf.registry.service.EntityService;
import eu.dariah.de.dariahsp.spring.mvc.AuthInfoHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportServiceImpl
implements ImportService,
InitializingBean,
PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(ImportServiceImpl.class);
    @Autowired
    private EntityService entityService;
    @Autowired
    private EntityRepository entityRepo;
    @Autowired
    private ImportRepository importRepo;
    @Autowired
    private AuthInfoHelper authinfoHelper;
    protected ExecutorService importExecutor;
    private int maxPoolSize = 5;
    private Map<String, ImportResult> importRunnerIdResultMap;

    public void afterPropertiesSet() throws Exception {
        this.importExecutor = Executors.newFixedThreadPool(this.maxPoolSize);
        this.importRunnerIdResultMap = new HashMap();
    }

    public long deleteImport(String uniqueId) {
        Optional i = this.importRepo.findById((Object)uniqueId);
        if (i.isEmpty()) {
            return 0L;
        }
        return this.deleteImport((Import)i.get());
    }

    public long deleteImport(Import i) {
        Collection entities = this.entityRepo.findByImportId(i.getUniqueId());
        long count = entities.size();
        this.entityRepo.deleteAll((Iterable)entities);
        log.info("Deleting read-only import, deleted {} associated entites", (Object)count);
        this.importRepo.delete((Object)i);
        log.info("Deleted import: {}", (Object)i.getUniqueId());
        return count;
    }

    public RestActionResponse.ApiActionStatus getStatus(String runnerId) {
        if (runnerId == null || !this.importRunnerIdResultMap.containsKey(runnerId)) {
            return RestActionResponse.ApiActionStatus.NONE;
        }
        ImportResult result = (ImportResult)this.importRunnerIdResultMap.get(runnerId);
        if (result == null) {
            return RestActionResponse.ApiActionStatus.BUSY;
        }
        return RestActionResponse.ApiActionStatus.DONE;
    }

    public ImportResult getImportResult(String runnerId) {
        if (runnerId == null || !this.importRunnerIdResultMap.containsKey(runnerId)) {
            return null;
        }
        return (ImportResult)this.importRunnerIdResultMap.get(runnerId);
    }

    public void importAsync(ImportRunner ir) {
        this.importRunnerIdResultMap.put(ir.getImportRunnerId(), null);
        ir.addPropertyChangeListener((PropertyChangeListener)this);
        this.importExecutor.execute((Runnable)ir);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        ImportRunner ir = (ImportRunner)ImportRunner.class.cast(arg0.getSource());
        ImportResult result = arg0.getNewValue() == null ? null : (ImportResult)ImportResult.class.cast(arg0.getNewValue());
        this.importRunnerIdResultMap.put(ir.getImportRunnerId(), result);
    }
}

